/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\f\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u001e\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJF\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$J\u0016\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006,"}, d2={"Ldorkbox/util/MathUtil;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "clamp", "", "value", "min", "max", "", "", "", "intersectRange", "", "ax1", "ax2", "bx1", "bx2", "intersectRect", "x1", "y1", "w1", "h1", "x2", "y2", "w2", "h2", "isEven", "isInteger", "string", "isLong", "isNumber", "character", "", "sizeLimit", "isPowerOfTwo", "nextPowerOfTwo", "numberOfDigits", "number", "stripTrailingNonDigits", "text", "Utilities"})
public final class MathUtil {
    public static final MathUtil INSTANCE = new MathUtil();
    private static final String version = Sys.INSTANCE.getVersion();

    private MathUtil() {
    }

    public final String getVersion() {
        return version;
    }

    public final boolean isInteger(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.isNumber(string, 10L);
    }

    public final boolean isLong(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.isNumber(string, 19L);
    }

    public final boolean isNumber(char c) {
        return Intrinsics.compare((int)c, (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0;
    }

    public final boolean isNumber(String string, long l) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (l <= 0L) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (string.charAt(0) == '-') {
            if (n == 1) {
                return false;
            }
            n2 = 1;
        }
        if ((long)(n - n2) > l) {
            return false;
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Intrinsics.compare((int)c, (int)48) < 0 || Intrinsics.compare((int)c, (int)57) > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final int numberOfDigits(long l) {
        long l2 = l;
        if (l2 < 0L) {
            l2 = -l2;
        }
        return l2 < 10000L ? (l2 < 100L ? (l2 < 10L ? 1 : 2) : (l2 < 1000L ? 3 : 4)) : (l2 < 1000000000000L ? (l2 < 100000000L ? (l2 < 1000000L ? (l2 < 100000L ? 5 : 6) : (l2 < 10000000L ? 7 : 8)) : (l2 < 10000000000L ? (l2 < 1000000000L ? 9 : 10) : (l2 < 100000000000L ? 11 : 12))) : (l2 < 10000000000000000L ? (l2 < 100000000000000L ? (l2 < 10000000000000L ? 13 : 14) : (l2 < 1000000000000000L ? 15 : 16)) : (l2 < 1000000000000000000L ? (l2 < 100000000000000000L ? 17 : 18) : 19)));
    }

    public final int stripTrailingNonDigits(String string) {
        int n;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (((CharSequence)string).length() == 0) {
            return 0;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(0, n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        try {
            return Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public final boolean isEven(int n) {
        return (n & 1) == 0;
    }

    public final int nextPowerOfTwo(int n) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public final boolean isPowerOfTwo(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public final boolean intersectRect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return this.intersectRange(d, d + d3, d5, d5 + d7) && this.intersectRange(d2, d2 + d4, d6, d6 + d8);
    }

    public final boolean intersectRange(double d, double d2, double d3, double d4) {
        return Math.max(d, d3) <= Math.min(d2, d4);
    }

    public final int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public final long clamp(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l3, l));
    }

    public final float clamp(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f3, f));
    }

    public final double clamp(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }
}

