/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.userManagement;

import dorkbox.util.userManagement.UserManagement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public final class Group
implements Serializable {
    private final UUID uuid;
    private String name;
    private Set<UUID> users = new HashSet<UUID>();

    public Group(String string) {
        this(string, UserManagement.UUID_GENERATOR.a());
    }

    Group(String string, UUID uUID) {
        this.name = string;
        this.uuid = uUID;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addUser(UUID uUID) {
        this.users.add(uUID);
    }

    public synchronized void removeUser(UUID uUID) {
        this.users.remove(uUID);
    }

    public synchronized Collection<UUID> getUsers() {
        return Collections.unmodifiableCollection(this.users);
    }

    public synchronized boolean isEmpty() {
        return this.users.isEmpty();
    }

    public synchronized void remove() {
        this.users.clear();
    }

    public String toString() {
        return "Group '" + this.name + '\'';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Group group = (Group)object;
        return this.uuid != null ? this.uuid.equals(group.uuid) : group.uuid == null;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }
}

