/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvMemStorage;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvMemStorage
extends Pointer {
    public AbstractCvMemStorage(Pointer pointer) {
        super(pointer);
    }

    public static CvMemStorage create(int n) {
        CvMemStorage cvMemStorage = opencv_core.cvCreateMemStorage(n);
        if (cvMemStorage != null) {
            cvMemStorage.deallocator(new ReleaseDeallocator(cvMemStorage));
        }
        return cvMemStorage;
    }

    public static CvMemStorage create() {
        return AbstractCvMemStorage.create(0);
    }

    public void release() {
        this.deallocate();
    }

    static {
        Loader.load();
    }

    protected static class ReleaseDeallocator
    extends CvMemStorage
    implements Pointer.Deallocator {
        ReleaseDeallocator(CvMemStorage cvMemStorage) {
            super(cvMemStorage);
        }

        public void deallocate() {
            opencv_core.cvReleaseMemStorage(this);
        }
    }
}

