/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvScalar;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvScalar
extends DoublePointer {
    public static final CvScalar ZERO;
    public static final CvScalar ONE;
    public static final CvScalar ONEHALF;
    public static final CvScalar ALPHA1;
    public static final CvScalar ALPHA255;
    public static final CvScalar WHITE;
    public static final CvScalar GRAY;
    public static final CvScalar BLACK;
    public static final CvScalar RED;
    public static final CvScalar GREEN;
    public static final CvScalar BLUE;
    public static final CvScalar CYAN;
    public static final CvScalar MAGENTA;
    public static final CvScalar YELLOW;

    public AbstractCvScalar(Pointer pointer) {
        super(pointer);
    }

    public abstract double val(int var1);

    public abstract CvScalar val(int var1, double var2);

    public double getVal(int n) {
        return this.val(n);
    }

    public CvScalar setVal(int n, double d) {
        return this.val(n, d);
    }

    public abstract DoublePointer val();

    public DoublePointer getDoublePointerVal() {
        return this.val();
    }

    public LongPointer getLongPointerVal() {
        return new LongPointer((Pointer)this.val());
    }

    public void scale(double d) {
        for (int i = 0; i < 4; ++i) {
            this.val(i, this.val(i) * d);
        }
    }

    public double red() {
        return this.val(2);
    }

    public double green() {
        return this.val(1);
    }

    public double blue() {
        return this.val(0);
    }

    public CvScalar red(double d) {
        this.val(2, d);
        return (CvScalar)this;
    }

    public CvScalar green(double d) {
        this.val(1, d);
        return (CvScalar)this;
    }

    public CvScalar blue(double d) {
        this.val(0, d);
        return (CvScalar)this;
    }

    public double magnitude() {
        return Math.sqrt(this.val(0) * this.val(0) + this.val(1) * this.val(1) + this.val(2) * this.val(2) + this.val(3) * this.val(3));
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + (float)this.val(0) + ", " + (float)this.val(1) + ", " + (float)this.val(2) + ", " + (float)this.val(3) + ")";
        }
        String string = "";
        long l = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            string = string + (i == 0L ? "(" : " (") + (float)this.val(0) + ", " + (float)this.val(1) + ", " + (float)this.val(2) + ", " + (float)this.val(3) + ")";
        }
        this.position(l);
        return string;
    }

    static {
        Loader.load();
        ZERO = (CvScalar)new CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 0.0).retainReference();
        ONE = (CvScalar)new CvScalar().val(0, 1.0).val(1, 1.0).val(2, 1.0).val(3, 1.0).retainReference();
        ONEHALF = (CvScalar)new CvScalar().val(0, 0.5).val(1, 0.5).val(2, 0.5).val(3, 0.5).retainReference();
        ALPHA1 = (CvScalar)new CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 1.0).retainReference();
        ALPHA255 = (CvScalar)new CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 255.0).retainReference();
        WHITE = (CvScalar)opencv_core.CV_RGB(255.0, 255.0, 255.0).retainReference();
        GRAY = (CvScalar)opencv_core.CV_RGB(128.0, 128.0, 128.0).retainReference();
        BLACK = (CvScalar)opencv_core.CV_RGB(0.0, 0.0, 0.0).retainReference();
        RED = (CvScalar)opencv_core.CV_RGB(255.0, 0.0, 0.0).retainReference();
        GREEN = (CvScalar)opencv_core.CV_RGB(0.0, 255.0, 0.0).retainReference();
        BLUE = (CvScalar)opencv_core.CV_RGB(0.0, 0.0, 255.0).retainReference();
        CYAN = (CvScalar)opencv_core.CV_RGB(0.0, 255.0, 255.0).retainReference();
        MAGENTA = (CvScalar)opencv_core.CV_RGB(255.0, 0.0, 255.0).retainReference();
        YELLOW = (CvScalar)opencv_core.CV_RGB(255.0, 255.0, 0.0).retainReference();
    }
}

