/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.KeyPoint;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::KeyPoint>"})
@Properties(inherit={opencv_core.class})
public class KeyPointVector
extends Pointer {
    public KeyPointVector(Pointer pointer) {
        super(pointer);
    }

    public KeyPointVector(KeyPoint keyPoint) {
        this(1L);
        this.put(0L, keyPoint);
    }

    public KeyPointVector(KeyPoint ... keyPointArray) {
        this(keyPointArray.length);
        this.put(keyPointArray);
    }

    public KeyPointVector() {
        this.allocate();
    }

    public KeyPointVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native KeyPointVector put(@ByRef KeyPointVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public KeyPoint front() {
        return this.get(0L);
    }

    public KeyPoint back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native KeyPoint get(@Cast(value={"size_t"}) long var1);

    public native KeyPointVector put(@Cast(value={"size_t"}) long var1, KeyPoint var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef KeyPoint var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public KeyPoint[] get() {
        KeyPoint[] keyPointArray = new KeyPoint[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < keyPointArray.length; ++i) {
            keyPointArray[i] = this.get(i);
        }
        return keyPointArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public KeyPoint pop_back() {
        long l = this.size();
        KeyPoint keyPoint = this.get(l - 1L);
        this.resize(l - 1L);
        return keyPoint;
    }

    public KeyPointVector push_back(KeyPoint keyPoint) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, keyPoint);
    }

    public KeyPointVector put(KeyPoint keyPoint) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, keyPoint);
    }

    public KeyPointVector put(KeyPoint ... keyPointArray) {
        if (this.size() != (long)keyPointArray.length) {
            this.resize(keyPointArray.length);
        }
        for (int i = 0; i < keyPointArray.length; ++i) {
            this.put(i, keyPointArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native KeyPoint get();
    }
}

