/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point2d;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Point2d>"})
@Properties(inherit={opencv_core.class})
public class Point2dVector
extends Pointer {
    public Point2dVector(Pointer pointer) {
        super(pointer);
    }

    public Point2dVector(Point2d point2d) {
        this(1L);
        this.put(0L, point2d);
    }

    public Point2dVector(Point2d ... point2dArray) {
        this(point2dArray.length);
        this.put(point2dArray);
    }

    public Point2dVector() {
        this.allocate();
    }

    public Point2dVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Point2dVector put(@ByRef Point2dVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point2d front() {
        return this.get(0L);
    }

    public Point2d back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Point2d get(@Cast(value={"size_t"}) long var1);

    public native Point2dVector put(@Cast(value={"size_t"}) long var1, Point2d var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point2d var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point2d[] get() {
        Point2d[] point2dArray = new Point2d[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < point2dArray.length; ++i) {
            point2dArray[i] = this.get(i);
        }
        return point2dArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point2d pop_back() {
        long l = this.size();
        Point2d point2d = this.get(l - 1L);
        this.resize(l - 1L);
        return point2d;
    }

    public Point2dVector push_back(Point2d point2d) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, point2d);
    }

    public Point2dVector put(Point2d point2d) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, point2d);
    }

    public Point2dVector put(Point2d ... point2dArray) {
        if (this.size() != (long)point2dArray.length) {
            this.resize(point2dArray.length);
        }
        for (int i = 0; i < point2dArray.length; ++i) {
            this.put(i, point2dArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Point2d get();
    }
}

