/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Rect>"})
@Properties(inherit={opencv_core.class})
public class RectVector
extends Pointer {
    public RectVector(Pointer pointer) {
        super(pointer);
    }

    public RectVector(Rect rect) {
        this(1L);
        this.put(0L, rect);
    }

    public RectVector(Rect ... rectArray) {
        this(rectArray.length);
        this.put(rectArray);
    }

    public RectVector() {
        this.allocate();
    }

    public RectVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native RectVector put(@ByRef RectVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Rect front() {
        return this.get(0L);
    }

    public Rect back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Rect get(@Cast(value={"size_t"}) long var1);

    public native RectVector put(@Cast(value={"size_t"}) long var1, Rect var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Rect var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Rect[] get() {
        Rect[] rectArray = new Rect[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < rectArray.length; ++i) {
            rectArray[i] = this.get(i);
        }
        return rectArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Rect pop_back() {
        long l = this.size();
        Rect rect = this.get(l - 1L);
        this.resize(l - 1L);
        return rect;
    }

    public RectVector push_back(Rect rect) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, rect);
    }

    public RectVector put(Rect rect) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, rect);
    }

    public RectVector put(Rect ... rectArray) {
        if (this.size() != (long)rectArray.length) {
            this.resize(rectArray.length);
        }
        for (int i = 0; i < rectArray.length; ++i) {
            this.put(i, rectArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Rect get();
    }
}

