/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_dnn;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Range;
import org.bytedeco.opencv.presets.opencv_dnn;

@Name(value={"std::vector<std::vector<cv::Range> >"})
@Properties(inherit={opencv_dnn.class})
public class RangeVectorVector
extends Pointer {
    public RangeVectorVector(Pointer pointer) {
        super(pointer);
    }

    public RangeVectorVector(Range[] ... rangeArray) {
        this(rangeArray.length);
        this.put(rangeArray);
    }

    public RangeVectorVector() {
        this.allocate();
    }

    public RangeVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native RangeVectorVector put(@ByRef RangeVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public boolean empty(@Cast(value={"size_t"}) long l) {
        return this.size(l) == 0L;
    }

    @Index(function="at")
    public native long size(@Cast(value={"size_t"}) long var1);

    public void clear(@Cast(value={"size_t"}) long l) {
        this.resize(l, 0L);
    }

    @Index(function="at")
    public native void resize(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    @Index(function="at")
    @ByRef
    public native Range get(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    public native RangeVectorVector put(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3, Range var5);

    public Range[][] get() {
        Range[][] rangeArray = new Range[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE][];
        for (int i = 0; i < rangeArray.length; ++i) {
            rangeArray[i] = new Range[this.size(i) < Integer.MAX_VALUE ? (int)this.size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < rangeArray[i].length; ++j) {
                rangeArray[i][j] = this.get(i, j);
            }
        }
        return rangeArray;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.get());
    }

    public RangeVectorVector put(Range[] ... rangeArray) {
        if (this.size() != (long)rangeArray.length) {
            this.resize(rangeArray.length);
        }
        for (int i = 0; i < rangeArray.length; ++i) {
            if (this.size(i) != (long)rangeArray[i].length) {
                this.resize(i, rangeArray[i].length);
            }
            for (int j = 0; j < rangeArray[i].length; ++j) {
                this.put(i, j, rangeArray[i][j]);
            }
        }
        return this;
    }

    static {
        Loader.load();
    }
}

