/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec6f>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec6fVector
extends Pointer {
    public Vec6fVector(Pointer pointer) {
        super(pointer);
    }

    public Vec6fVector(FloatPointer floatPointer) {
        this(1L);
        this.put(0L, floatPointer);
    }

    public Vec6fVector(FloatPointer ... floatPointerArray) {
        this(floatPointerArray.length);
        this.put(floatPointerArray);
    }

    public Vec6fVector() {
        this.allocate();
    }

    public Vec6fVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Vec6fVector put(@ByRef Vec6fVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public FloatPointer front() {
        return this.get(0L);
    }

    public FloatPointer back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Cast(value={"cv::Vec6f*"})
    @ByRef
    public native FloatPointer get(@Cast(value={"size_t"}) long var1);

    public native Vec6fVector put(@Cast(value={"size_t"}) long var1, FloatPointer var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec6f*"}) @ByRef FloatPointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public FloatPointer[] get() {
        FloatPointer[] floatPointerArray = new FloatPointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < floatPointerArray.length; ++i) {
            floatPointerArray[i] = this.get(i);
        }
        return floatPointerArray;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public FloatPointer pop_back() {
        long l = this.size();
        FloatPointer floatPointer = this.get(l - 1L);
        this.resize(l - 1L);
        return floatPointer;
    }

    public Vec6fVector push_back(FloatPointer floatPointer) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, floatPointer);
    }

    public Vec6fVector put(FloatPointer floatPointer) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, floatPointer);
    }

    public Vec6fVector put(FloatPointer ... floatPointerArray) {
        if (this.size() != (long)floatPointerArray.length) {
            this.resize(floatPointerArray.length);
        }
        for (int i = 0; i < floatPointerArray.length; ++i) {
            this.put(i, floatPointerArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"cv::Vec6f*"})
        @ByRef
        @Const
        public native FloatPointer get();
    }
}

