/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_text;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_text;

@Name(value={"std::vector<float>"})
@Properties(inherit={opencv_text.class})
public class FloatVector
extends Pointer {
    public FloatVector(Pointer pointer) {
        super(pointer);
    }

    public FloatVector(float f) {
        this(1L);
        this.put(0L, f);
    }

    public FloatVector(float ... fArray) {
        this(fArray.length);
        this.put(fArray);
    }

    public FloatVector() {
        this.allocate();
    }

    public FloatVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native FloatVector put(@ByRef FloatVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public float front() {
        return this.get(0L);
    }

    public float back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native float get(@Cast(value={"size_t"}) long var1);

    public native FloatVector put(@Cast(value={"size_t"}) long var1, float var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, float var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public float[] get() {
        float[] fArray = new float[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.get(i);
        }
        return fArray;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public float pop_back() {
        long l = this.size();
        float f = this.get(l - 1L);
        this.resize(l - 1L);
        return f;
    }

    public FloatVector push_back(float f) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, f);
    }

    public FloatVector put(float f) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, f);
    }

    public FloatVector put(float ... fArray) {
        if (this.size() != (long)fArray.length) {
            this.resize(fArray.length);
        }
        for (int i = 0; i < fArray.length; ++i) {
            this.put(i, fArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        public native float get();
    }
}

