/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_tracking;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_tracking.TrackedObject;
import org.bytedeco.opencv.presets.opencv_tracking;

@Name(value={"std::deque<cv::detail::tracking::tbm::TrackedObject>"})
@Properties(inherit={opencv_tracking.class})
public class TrackedObjectDeque
extends Pointer {
    public TrackedObjectDeque(Pointer pointer) {
        super(pointer);
    }

    public TrackedObjectDeque(TrackedObject trackedObject) {
        this(1L);
        this.put(0L, trackedObject);
    }

    public TrackedObjectDeque(TrackedObject ... trackedObjectArray) {
        this(trackedObjectArray.length);
        this.put(trackedObjectArray);
    }

    public TrackedObjectDeque() {
        this.allocate();
    }

    public TrackedObjectDeque(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native TrackedObjectDeque put(@ByRef TrackedObjectDeque var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public TrackedObject front() {
        return this.get(0L);
    }

    public TrackedObject back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native TrackedObject get(@Cast(value={"size_t"}) long var1);

    public native TrackedObjectDeque put(@Cast(value={"size_t"}) long var1, TrackedObject var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef TrackedObject var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public TrackedObject[] get() {
        TrackedObject[] trackedObjectArray = new TrackedObject[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < trackedObjectArray.length; ++i) {
            trackedObjectArray[i] = this.get(i);
        }
        return trackedObjectArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public TrackedObject pop_back() {
        long l = this.size();
        TrackedObject trackedObject = this.get(l - 1L);
        this.resize(l - 1L);
        return trackedObject;
    }

    public TrackedObjectDeque push_back(TrackedObject trackedObject) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, trackedObject);
    }

    public TrackedObjectDeque put(TrackedObject trackedObject) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, trackedObject);
    }

    public TrackedObjectDeque put(TrackedObject ... trackedObjectArray) {
        if (this.size() != (long)trackedObjectArray.length) {
            this.resize(trackedObjectArray.length);
        }
        for (int i = 0; i < trackedObjectArray.length; ++i) {
            this.put(i, trackedObjectArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native TrackedObject get();
    }
}

