/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.collection.CharObjectMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.Closeable;

public class DefaultHttp2FrameWriter
implements Http2FrameSizePolicy,
Http2FrameWriter,
Http2FrameWriter.Configuration {
    private static final String STREAM_ID = "Stream ID";
    private static final String STREAM_DEPENDENCY = "Stream Dependency";
    private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)255).writeZero(255)).asReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this(new DefaultHttp2HeadersEncoder(sensitivityDetector));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean bl) {
        this(new DefaultHttp2HeadersEncoder(sensitivityDetector, bl));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder http2HeadersEncoder) {
        this.headersEncoder = http2HeadersEncoder;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this;
    }

    @Override
    public Http2HeadersEncoder.Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    @Override
    public void maxFrameSize(int n) {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n);
        }
        this.maxFrameSize = n;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
        if (this.headersEncoder instanceof Closeable) {
            try {
                ((Closeable)((Object)this.headersEncoder)).close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl, ChannelPromise channelPromise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        ByteBuf byteBuf2 = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n, STREAM_ID);
            Http2CodecUtil.verifyPadding(n2);
            int n3 = byteBuf.readableBytes();
            Http2Flags http2Flags = new Http2Flags();
            http2Flags.endOfStream(false);
            http2Flags.paddingPresent(false);
            if (n3 > this.maxFrameSize) {
                byteBuf2 = channelHandlerContext.alloc().buffer(9);
                Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, this.maxFrameSize, (byte)0, http2Flags, n);
                do {
                    channelHandlerContext.write((Object)byteBuf2.retainedSlice(), simpleChannelPromiseAggregator.newPromise());
                    channelHandlerContext.write((Object)byteBuf.readRetainedSlice(this.maxFrameSize), simpleChannelPromiseAggregator.newPromise());
                } while ((n3 -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (n2 == 0) {
                if (byteBuf2 != null) {
                    byteBuf2.release();
                    byteBuf2 = null;
                }
                ByteBuf byteBuf3 = channelHandlerContext.alloc().buffer(9);
                http2Flags.endOfStream(bl);
                Http2CodecUtil.writeFrameHeaderInternal(byteBuf3, n3, (byte)0, http2Flags, n);
                channelHandlerContext.write((Object)byteBuf3, simpleChannelPromiseAggregator.newPromise());
                ByteBuf byteBuf4 = byteBuf.readSlice(n3);
                byteBuf = null;
                channelHandlerContext.write((Object)byteBuf4, simpleChannelPromiseAggregator.newPromise());
            } else {
                if (n3 != this.maxFrameSize) {
                    if (byteBuf2 != null) {
                        byteBuf2.release();
                        byteBuf2 = null;
                    }
                } else {
                    ByteBuf byteBuf5;
                    n3 -= this.maxFrameSize;
                    if (byteBuf2 == null) {
                        byteBuf5 = channelHandlerContext.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(byteBuf5, this.maxFrameSize, (byte)0, http2Flags, n);
                    } else {
                        byteBuf5 = byteBuf2.slice();
                        byteBuf2 = null;
                    }
                    channelHandlerContext.write((Object)byteBuf5, simpleChannelPromiseAggregator.newPromise());
                    byteBuf5 = byteBuf.readableBytes() != this.maxFrameSize ? byteBuf.readSlice(this.maxFrameSize) : byteBuf;
                    byteBuf = null;
                    channelHandlerContext.write((Object)byteBuf5, simpleChannelPromiseAggregator.newPromise());
                }
                do {
                    int n4 = Math.min(n3, this.maxFrameSize);
                    int n5 = Math.min(n2, Math.max(0, this.maxFrameSize - 1 - n4));
                    ByteBuf byteBuf6 = channelHandlerContext.alloc().buffer(10);
                    http2Flags.endOfStream(bl && (n3 -= n4) == 0 && (n2 -= n5) == 0);
                    http2Flags.paddingPresent(n5 > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf6, n5 + n4, (byte)0, http2Flags, n);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf6, n5);
                    channelHandlerContext.write((Object)byteBuf6, simpleChannelPromiseAggregator.newPromise());
                    if (byteBuf != null) {
                        if (n3 == 0) {
                            ByteBuf byteBuf7 = byteBuf.readSlice(n4);
                            byteBuf = null;
                            channelHandlerContext.write((Object)byteBuf7, simpleChannelPromiseAggregator.newPromise());
                        } else {
                            channelHandlerContext.write((Object)byteBuf.readRetainedSlice(n4), simpleChannelPromiseAggregator.newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(n5) <= 0) continue;
                    channelHandlerContext.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n5)), simpleChannelPromiseAggregator.newPromise());
                } while (n3 != 0 || n2 != 0);
            }
        }
        catch (Throwable throwable) {
            if (byteBuf2 != null) {
                byteBuf2.release();
            }
            try {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
            finally {
                simpleChannelPromiseAggregator.setFailure(throwable);
                simpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return simpleChannelPromiseAggregator;
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n, http2Headers, n2, bl, false, 0, (short)0, false, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n, http2Headers, n3, bl2, true, n2, s, bl, channelPromise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, STREAM_DEPENDENCY);
            DefaultHttp2FrameWriter.verifyWeight(s);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 5, (byte)2, new Http2Flags(), n);
            byteBuf.writeInt(bl ? (int)(0x80000000L | (long)n2) : n2);
            byteBuf.writeByte(s - 1);
            return channelHandlerContext.write((Object)byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n, STREAM_ID);
            DefaultHttp2FrameWriter.verifyErrorCode(l);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)3, new Http2Flags(), n);
            byteBuf.writeInt((int)l);
            return channelHandlerContext.write((Object)byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        try {
            ObjectUtil.checkNotNull((Object)((Object)http2Settings), (String)"settings");
            int n = 6 * http2Settings.size();
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9 + n);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, n, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap.PrimitiveEntry primitiveEntry : http2Settings.entries()) {
                byteBuf.writeChar((int)primitiveEntry.key());
                byteBuf.writeInt(((Long)primitiveEntry.value()).intValue());
            }
            return channelHandlerContext.write((Object)byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        try {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return channelHandlerContext.write((Object)byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l, ChannelPromise channelPromise) {
        Http2Flags http2Flags = bl ? new Http2Flags().ack(true) : new Http2Flags();
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer(17);
        Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 8, (byte)6, http2Flags, 0);
        byteBuf.writeLong(l);
        return channelHandlerContext.write((Object)byteBuf, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3, ChannelPromise channelPromise) {
        ByteBuf byteBuf = null;
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(n2, "Promised Stream ID");
            Http2CodecUtil.verifyPadding(n3);
            byteBuf = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n, http2Headers, byteBuf);
            Http2Flags http2Flags = new Http2Flags().paddingPresent(n3 > 0);
            int n4 = 4 + n3;
            int n5 = this.maxFrameSize - n4;
            ByteBuf byteBuf2 = byteBuf.readRetainedSlice(Math.min(byteBuf.readableBytes(), n5));
            http2Flags.endOfHeaders(!byteBuf.isReadable());
            int n6 = byteBuf2.readableBytes() + n4;
            ByteBuf byteBuf3 = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf3, n6, (byte)5, http2Flags, n);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf3, n3);
            byteBuf3.writeInt(n2);
            channelHandlerContext.write((Object)byteBuf3, simpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write((Object)byteBuf2, simpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n3) > 0) {
                channelHandlerContext.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n3)), simpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n, byteBuf, simpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            simpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            simpleChannelPromiseAggregator.setFailure(throwable);
            simpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException((Throwable)throwable);
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(l);
            int n2 = 8 + byteBuf.readableBytes();
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(17);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n2, (byte)7, new Http2Flags(), 0);
            byteBuf2.writeInt(n);
            byteBuf2.writeInt((int)l);
            channelHandlerContext.write((Object)byteBuf2, simpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                simpleChannelPromiseAggregator.setFailure(throwable);
                simpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return simpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write((Object)byteBuf, simpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            simpleChannelPromiseAggregator.setFailure(throwable);
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n, int n2, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n, STREAM_ID);
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(n2);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)8, new Http2Flags(), n);
            byteBuf.writeInt(n2);
            return channelHandlerContext.write((Object)byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n, STREAM_ID);
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, byteBuf.readableBytes(), by, http2Flags, n);
            channelHandlerContext.write((Object)byteBuf2, simpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                simpleChannelPromiseAggregator.setFailure(throwable);
                simpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return simpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write((Object)byteBuf, simpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            simpleChannelPromiseAggregator.setFailure(throwable);
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture writeHeadersInternal(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl, boolean bl2, int n3, short s, boolean bl3, ChannelPromise channelPromise) {
        ByteBuf byteBuf = null;
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n, STREAM_ID);
            if (bl2) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n3, STREAM_DEPENDENCY);
                Http2CodecUtil.verifyPadding(n2);
                DefaultHttp2FrameWriter.verifyWeight(s);
            }
            byteBuf = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n, http2Headers, byteBuf);
            Http2Flags http2Flags = new Http2Flags().endOfStream(bl).priorityPresent(bl2).paddingPresent(n2 > 0);
            int n4 = n2 + http2Flags.getNumPriorityBytes();
            int n5 = this.maxFrameSize - n4;
            ByteBuf byteBuf2 = byteBuf.readRetainedSlice(Math.min(byteBuf.readableBytes(), n5));
            http2Flags.endOfHeaders(!byteBuf.isReadable());
            int n6 = byteBuf2.readableBytes() + n4;
            ByteBuf byteBuf3 = channelHandlerContext.alloc().buffer(15);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf3, n6, (byte)1, http2Flags, n);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf3, n2);
            if (bl2) {
                byteBuf3.writeInt(bl3 ? (int)(0x80000000L | (long)n3) : n3);
                byteBuf3.writeByte(s - 1);
            }
            channelHandlerContext.write((Object)byteBuf3, simpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write((Object)byteBuf2, simpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n2) > 0) {
                channelHandlerContext.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n2)), simpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n, byteBuf, simpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            simpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            simpleChannelPromiseAggregator.setFailure(throwable);
            simpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException((Throwable)throwable);
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        return simpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    private ChannelFuture writeContinuationFrames(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator) {
        Http2Flags http2Flags = new Http2Flags();
        if (byteBuf.isReadable()) {
            ByteBuf byteBuf2 = null;
            do {
                int n2 = Math.min(byteBuf.readableBytes(), this.maxFrameSize);
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n2);
                if (byteBuf.isReadable()) {
                    if (byteBuf2 == null) {
                        byteBuf2 = channelHandlerContext.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n2, (byte)9, http2Flags, n);
                    }
                    channelHandlerContext.write((Object)byteBuf2.retainedSlice(), simpleChannelPromiseAggregator.newPromise());
                } else {
                    if (byteBuf2 != null) {
                        byteBuf2.release();
                    }
                    http2Flags = http2Flags.endOfHeaders(true);
                    byteBuf2 = channelHandlerContext.alloc().buffer(9);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n2, (byte)9, http2Flags, n);
                    channelHandlerContext.write((Object)byteBuf2, simpleChannelPromiseAggregator.newPromise());
                }
                channelHandlerContext.write((Object)byteBuf3, simpleChannelPromiseAggregator.newPromise());
            } while (byteBuf.isReadable());
        }
        return simpleChannelPromiseAggregator;
    }

    private static int paddingBytes(int n) {
        return n - 1;
    }

    private static void writePaddingLength(ByteBuf byteBuf, int n) {
        if (n > 0) {
            byteBuf.writeByte(n - 1);
        }
    }

    private static void verifyStreamId(int n, String string) {
        ObjectUtil.checkPositive((int)n, (String)string);
    }

    private static void verifyStreamOrConnectionId(int n, String string) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)string);
    }

    private static void verifyWeight(short s) {
        if (s < 1 || s > 256) {
            throw new IllegalArgumentException("Invalid weight: " + s);
        }
    }

    private static void verifyErrorCode(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid errorCode: " + l);
        }
    }

    private static void verifyWindowSizeIncrement(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"windowSizeIncrement");
    }
}

