/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final HpackDecoder hpackDecoder;
    private final boolean validateHeaders;
    private final boolean validateHeaderValues;
    private long maxHeaderListSizeGoAway;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean bl) {
        this(bl, 8192L);
    }

    public DefaultHttp2HeadersDecoder(boolean bl, boolean bl2) {
        this(bl, bl2, 8192L);
    }

    public DefaultHttp2HeadersDecoder(boolean bl, long l) {
        this(bl, false, new HpackDecoder(l));
    }

    public DefaultHttp2HeadersDecoder(boolean bl, boolean bl2, long l) {
        this(bl, bl2, new HpackDecoder(l));
    }

    public DefaultHttp2HeadersDecoder(boolean bl, long l, @Deprecated int n) {
        this(bl, false, new HpackDecoder(l));
    }

    DefaultHttp2HeadersDecoder(boolean bl, boolean bl2, HpackDecoder hpackDecoder) {
        this.hpackDecoder = (HpackDecoder)ObjectUtil.checkNotNull((Object)hpackDecoder, (String)"hpackDecoder");
        this.validateHeaders = bl;
        this.validateHeaderValues = bl2;
        this.maxHeaderListSizeGoAway = Http2CodecUtil.calculateMaxHeaderListSizeGoAway(hpackDecoder.getMaxHeaderListSize());
    }

    @Override
    public void maxHeaderTableSize(long l) {
        this.hpackDecoder.setMaxHeaderTableSize(l);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.hpackDecoder.getMaxHeaderTableSize();
    }

    @Override
    public void maxHeaderListSize(long l, long l2) {
        if (l2 < l || l2 < 0L) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Header List Size GO_AWAY %d must be non-negative and >= %d", l2, l);
        }
        this.hpackDecoder.setMaxHeaderListSize(l);
        this.maxHeaderListSizeGoAway = l2;
    }

    @Override
    public long maxHeaderListSize() {
        return this.hpackDecoder.getMaxHeaderListSize();
    }

    @Override
    public long maxHeaderListSizeGoAway() {
        return this.maxHeaderListSizeGoAway;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    @Override
    public Http2Headers decodeHeaders(int n, ByteBuf byteBuf) {
        try {
            Http2Headers http2Headers = this.newHeaders();
            this.hpackDecoder.decode(n, byteBuf, http2Headers, this.validateHeaders);
            this.headerArraySizeAccumulator = 0.2f * (float)http2Headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return http2Headers;
        }
        catch (Http2Exception http2Exception) {
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable, "Error decoding headers: %s", throwable.getMessage());
        }
    }

    protected final int numberOfHeadersGuess() {
        return (int)this.headerArraySizeAccumulator;
    }

    protected final boolean validateHeaders() {
        return this.validateHeaders;
    }

    protected boolean validateHeaderValues() {
        return this.validateHeaderValues;
    }

    protected Http2Headers newHeaders() {
        return new DefaultHttp2Headers(this.validateHeaders, this.validateHeaderValues, (int)this.headerArraySizeAccumulator);
    }
}

