/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http2.HpackDynamicTable;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanDecoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;

final class HpackDecoder {
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - long overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - int overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128ToInt(..)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decode(..)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "indexHeader(..)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "readName(..)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "setDynamicTableSize(..)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decode(..)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_INDEXED_HEADER = 1;
    private static final byte READ_INDEXED_HEADER_NAME = 2;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 4;
    private static final byte READ_LITERAL_HEADER_NAME = 5;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 7;
    private static final byte READ_LITERAL_HEADER_VALUE = 8;
    private final HpackHuffmanDecoder huffmanDecoder = new HpackHuffmanDecoder();
    private final HpackDynamicTable hpackDynamicTable;
    private long maxHeaderListSize;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    HpackDecoder(long l) {
        this(l, 4096);
    }

    HpackDecoder(long l, int n) {
        this.maxHeaderListSize = ObjectUtil.checkPositive((long)l, (String)"maxHeaderListSize");
        this.maxDynamicTableSize = this.encoderMaxDynamicTableSize = (long)n;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable = new HpackDynamicTable(n);
    }

    void decode(int n, ByteBuf byteBuf, Http2Headers http2Headers, boolean bl) {
        Http2HeadersSink http2HeadersSink = new Http2HeadersSink(n, http2Headers, this.maxHeaderListSize, bl);
        this.decodeDynamicTableSizeUpdates(byteBuf);
        this.decode(byteBuf, http2HeadersSink);
        http2HeadersSink.finish();
    }

    private void decodeDynamicTableSizeUpdates(ByteBuf byteBuf) {
        byte by;
        while (byteBuf.isReadable() && ((by = byteBuf.getByte(byteBuf.readerIndex())) & 0x20) == 32 && (by & 0xC0) == 0) {
            byteBuf.readByte();
            int n = by & 0x1F;
            if (n == 31) {
                this.setDynamicTableSize(HpackDecoder.decodeULE128(byteBuf, (long)n));
                continue;
            }
            this.setDynamicTableSize(n);
        }
    }

    private void decode(ByteBuf byteBuf, Http2HeadersSink http2HeadersSink) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        AsciiString asciiString = null;
        HpackUtil.IndexType indexType = HpackUtil.IndexType.NONE;
        block27: while (byteBuf.isReadable()) {
            switch (n4) {
                case 0: {
                    HpackHeaderField hpackHeaderField;
                    byte by = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (by & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (by < 0) {
                        n = by & 0x7F;
                        switch (n) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                n4 = 1;
                                continue block27;
                            }
                        }
                        hpackHeaderField = this.getIndexedHeader(n);
                        http2HeadersSink.appendToHeaderList((AsciiString)hpackHeaderField.name, (AsciiString)hpackHeaderField.value);
                        continue block27;
                    }
                    if ((by & 0x40) == 64) {
                        indexType = HpackUtil.IndexType.INCREMENTAL;
                        n = by & 0x3F;
                        switch (n) {
                            case 0: {
                                n4 = 3;
                                continue block27;
                            }
                            case 63: {
                                n4 = 2;
                                continue block27;
                            }
                        }
                        asciiString = this.readName(n);
                        n2 = asciiString.length();
                        n4 = 6;
                        continue block27;
                    }
                    if ((by & 0x20) == 32) {
                        throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Dynamic table size update must happen at the beginning of the header block", new Object[0]);
                    }
                    indexType = (by & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    n = by & 0xF;
                    switch (n) {
                        case 0: {
                            n4 = 3;
                            continue block27;
                        }
                        case 15: {
                            n4 = 2;
                            continue block27;
                        }
                    }
                    asciiString = this.readName(n);
                    n2 = asciiString.length();
                    n4 = 6;
                    continue block27;
                }
                case 1: {
                    HpackHeaderField hpackHeaderField = this.getIndexedHeader(HpackDecoder.decodeULE128(byteBuf, n));
                    http2HeadersSink.appendToHeaderList((AsciiString)hpackHeaderField.name, (AsciiString)hpackHeaderField.value);
                    n4 = 0;
                    continue block27;
                }
                case 2: {
                    asciiString = this.readName(HpackDecoder.decodeULE128(byteBuf, n));
                    n2 = asciiString.length();
                    n4 = 6;
                    continue block27;
                }
                case 3: {
                    byte by = byteBuf.readByte();
                    bl = (by & 0x80) == 128;
                    n = by & 0x7F;
                    if (n == 127) {
                        n4 = 4;
                        continue block27;
                    }
                    n2 = n;
                    n4 = 5;
                    continue block27;
                }
                case 4: {
                    n2 = HpackDecoder.decodeULE128(byteBuf, n);
                    n4 = 5;
                    continue block27;
                }
                case 5: {
                    if (byteBuf.readableBytes() < n2) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    asciiString = this.readStringLiteral(byteBuf, n2, bl);
                    n4 = 6;
                    continue block27;
                }
                case 6: {
                    byte by = byteBuf.readByte();
                    bl = (by & 0x80) == 128;
                    n = by & 0x7F;
                    switch (n) {
                        case 127: {
                            n4 = 7;
                            continue block27;
                        }
                        case 0: {
                            this.insertHeader(http2HeadersSink, asciiString, AsciiString.EMPTY_STRING, indexType);
                            n4 = 0;
                            continue block27;
                        }
                    }
                    n3 = n;
                    n4 = 8;
                    continue block27;
                }
                case 7: {
                    n3 = HpackDecoder.decodeULE128(byteBuf, n);
                    n4 = 8;
                    continue block27;
                }
                case 8: {
                    if (byteBuf.readableBytes() < n3) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    AsciiString asciiString2 = this.readStringLiteral(byteBuf, n3, bl);
                    this.insertHeader(http2HeadersSink, asciiString, asciiString2, indexType);
                    n4 = 0;
                    continue block27;
                }
            }
            throw new Error("should not reach here state: " + n4);
        }
        if (n4 != 0) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Incomplete header block fragment.", new Object[0]);
        }
    }

    void setMaxHeaderTableSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxDynamicTableSize = l;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.hpackDynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    void setMaxHeaderListSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxHeaderListSize = l;
    }

    long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    long getMaxHeaderTableSize() {
        return this.hpackDynamicTable.capacity();
    }

    int length() {
        return this.hpackDynamicTable.length();
    }

    long size() {
        return this.hpackDynamicTable.size();
    }

    HpackHeaderField getHeaderField(int n) {
        return this.hpackDynamicTable.getEntry(n + 1);
    }

    private void setDynamicTableSize(long l) {
        if (l > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = l;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable.setCapacity(l);
    }

    private static HeaderType validateHeader(int n, AsciiString asciiString, CharSequence charSequence, HeaderType headerType) {
        if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)asciiString)) {
            HeaderType headerType2;
            if (headerType == HeaderType.REGULAR_HEADER) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Pseudo-header field '%s' found after regular header.", asciiString);
            }
            Http2Headers.PseudoHeaderName pseudoHeaderName = Http2Headers.PseudoHeaderName.getPseudoHeader(asciiString);
            HeaderType headerType3 = headerType2 = pseudoHeaderName.isRequestOnly() ? HeaderType.REQUEST_PSEUDO_HEADER : HeaderType.RESPONSE_PSEUDO_HEADER;
            if (headerType != null && headerType2 != headerType) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Mix of request and response pseudo-headers.", new Object[0]);
            }
            return headerType2;
        }
        if (HttpHeaderValidationUtil.isConnectionHeader((CharSequence)asciiString, (boolean)true)) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Illegal connection-specific header '%s' encountered.", asciiString);
        }
        if (HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)asciiString, (CharSequence)charSequence)) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Illegal value specified for the 'TE' header (only 'trailers' is allowed).", new Object[0]);
        }
        return HeaderType.REGULAR_HEADER;
    }

    private AsciiString readName(int n) {
        if (n <= HpackStaticTable.length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n);
            return (AsciiString)hpackHeaderField.name;
        }
        if (n - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            HpackHeaderField hpackHeaderField = this.hpackDynamicTable.getEntry(n - HpackStaticTable.length);
            return (AsciiString)hpackHeaderField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private HpackHeaderField getIndexedHeader(int n) {
        if (n <= HpackStaticTable.length) {
            return HpackStaticTable.getEntry(n);
        }
        if (n - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            return this.hpackDynamicTable.getEntry(n - HpackStaticTable.length);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private void insertHeader(Http2HeadersSink http2HeadersSink, AsciiString asciiString, AsciiString asciiString2, HpackUtil.IndexType indexType) {
        http2HeadersSink.appendToHeaderList(asciiString, asciiString2);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.hpackDynamicTable.add(new HpackHeaderField((CharSequence)asciiString, (CharSequence)asciiString2));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
    }

    private AsciiString readStringLiteral(ByteBuf byteBuf, int n, boolean bl) {
        if (bl) {
            return this.huffmanDecoder.decode(byteBuf, n);
        }
        byte[] byArray = new byte[n];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf byteBuf) {
        return new IllegalArgumentException("decode only works with an entire header block! " + byteBuf);
    }

    static int decodeULE128(ByteBuf byteBuf, int n) {
        int n2 = byteBuf.readerIndex();
        long l = HpackDecoder.decodeULE128(byteBuf, (long)n);
        if (l > Integer.MAX_VALUE) {
            byteBuf.readerIndex(n2);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)l;
    }

    static long decodeULE128(ByteBuf byteBuf, long l) {
        assert (l <= 127L && l >= 0L);
        boolean bl = l == 0L;
        int n = byteBuf.writerIndex();
        int n2 = byteBuf.readerIndex();
        int n3 = 0;
        while (n2 < n) {
            byte by = byteBuf.getByte(n2);
            if (n3 == 56 && ((by & 0x80) != 0 || by == 127 && !bl)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((by & 0x80) == 0) {
                byteBuf.readerIndex(n2 + 1);
                return l + (((long)by & 0x7FL) << n3);
            }
            l += ((long)by & 0x7FL) << n3;
            ++n2;
            n3 += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    private static final class Http2HeadersSink {
        private final Http2Headers headers;
        private final long maxHeaderListSize;
        private final int streamId;
        private final boolean validateHeaders;
        private long headersLength;
        private boolean exceededMaxLength;
        private HeaderType previousType;
        private Http2Exception validationException;

        Http2HeadersSink(int n, Http2Headers http2Headers, long l, boolean bl) {
            this.headers = http2Headers;
            this.maxHeaderListSize = l;
            this.streamId = n;
            this.validateHeaders = bl;
        }

        void finish() {
            if (this.exceededMaxLength) {
                Http2CodecUtil.headerListSizeExceeded(this.streamId, this.maxHeaderListSize, true);
            } else if (this.validationException != null) {
                throw this.validationException;
            }
        }

        void appendToHeaderList(AsciiString asciiString, AsciiString asciiString2) {
            this.headersLength += HpackHeaderField.sizeOf((CharSequence)asciiString, (CharSequence)asciiString2);
            this.exceededMaxLength |= this.headersLength > this.maxHeaderListSize;
            if (this.exceededMaxLength || this.validationException != null) {
                return;
            }
            try {
                this.headers.add(asciiString, asciiString2);
                if (this.validateHeaders) {
                    this.previousType = HpackDecoder.validateHeader(this.streamId, asciiString, (CharSequence)asciiString2, this.previousType);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.validationException = Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, illegalArgumentException, "Validation failed for header '%s': %s", asciiString, illegalArgumentException.getMessage());
            }
            catch (Http2Exception http2Exception) {
                this.validationException = Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, http2Exception, http2Exception.getMessage(), new Object[0]);
            }
        }
    }

    private static enum HeaderType {
        REGULAR_HEADER,
        REQUEST_PSEUDO_HEADER,
        RESPONSE_PSEUDO_HEADER;

    }
}

