/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.List;

final class HpackStaticTable {
    static final int NOT_FOUND = -1;
    private static final List<HpackHeaderField> STATIC_TABLE;
    private static final int HEADER_NAMES_TABLE_SIZE = 512;
    private static final int HEADER_NAMES_TABLE_SHIFT;
    private static final HeaderNameIndex[] HEADER_NAMES;
    private static final int HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SIZE = 64;
    private static final int HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT;
    private static final HeaderIndex[] HEADERS_WITH_NON_EMPTY_VALUES;
    static final int length;

    private static HpackHeaderField newEmptyHeaderField(AsciiString asciiString) {
        return new HpackHeaderField((CharSequence)asciiString, (CharSequence)AsciiString.EMPTY_STRING);
    }

    private static HpackHeaderField newEmptyHeaderField(String string) {
        return new HpackHeaderField((CharSequence)AsciiString.cached((String)string), (CharSequence)AsciiString.EMPTY_STRING);
    }

    private static HpackHeaderField newHeaderField(AsciiString asciiString, String string) {
        return new HpackHeaderField((CharSequence)asciiString, (CharSequence)AsciiString.cached((String)string));
    }

    private static HpackHeaderField newPseudoHeaderMethodField(HttpMethod httpMethod) {
        return new HpackHeaderField((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value(), (CharSequence)httpMethod.asciiName());
    }

    private static HpackHeaderField newPseudoHeaderField(Http2Headers.PseudoHeaderName pseudoHeaderName, AsciiString asciiString) {
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)asciiString);
    }

    private static HpackHeaderField newPseudoHeaderField(Http2Headers.PseudoHeaderName pseudoHeaderName, String string) {
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)AsciiString.cached((String)string));
    }

    private static HpackHeaderField newEmptyPseudoHeaderField(Http2Headers.PseudoHeaderName pseudoHeaderName) {
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)AsciiString.EMPTY_STRING);
    }

    static HpackHeaderField getEntry(int n) {
        return STATIC_TABLE.get(n - 1);
    }

    static int getIndex(CharSequence charSequence) {
        HeaderNameIndex headerNameIndex = HpackStaticTable.getEntry(charSequence);
        return headerNameIndex == null ? -1 : headerNameIndex.index;
    }

    static int getIndexInsensitive(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() == 0) {
            HeaderNameIndex headerNameIndex = HpackStaticTable.getEntry(charSequence);
            return headerNameIndex == null || !headerNameIndex.emptyValue ? -1 : headerNameIndex.index;
        }
        int n = HpackStaticTable.headerBucket(charSequence2);
        HeaderIndex headerIndex = HEADERS_WITH_NON_EMPTY_VALUES[n];
        if (headerIndex == null) {
            return -1;
        }
        if (HpackUtil.equalsVariableTime(headerIndex.name, charSequence) && HpackUtil.equalsVariableTime(headerIndex.value, charSequence2)) {
            return headerIndex.index;
        }
        return -1;
    }

    private static HeaderNameIndex getEntry(CharSequence charSequence) {
        int n = HpackStaticTable.headerNameBucket(charSequence);
        HeaderNameIndex headerNameIndex = HEADER_NAMES[n];
        if (headerNameIndex == null) {
            return null;
        }
        return HpackUtil.equalsVariableTime(headerNameIndex.name, charSequence) ? headerNameIndex : null;
    }

    private static int headerNameBucket(CharSequence charSequence) {
        return HpackStaticTable.bucket(charSequence, HEADER_NAMES_TABLE_SHIFT, 511);
    }

    private static int headerBucket(CharSequence charSequence) {
        return HpackStaticTable.bucket(charSequence, HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT, 63);
    }

    private static int bucket(CharSequence charSequence, int n, int n2) {
        return AsciiString.hashCode((CharSequence)charSequence) >> n & n2;
    }

    private HpackStaticTable() {
    }

    static {
        Object object;
        int n;
        HpackHeaderField hpackHeaderField;
        int n2;
        STATIC_TABLE = Arrays.asList(HpackStaticTable.newEmptyPseudoHeaderField(Http2Headers.PseudoHeaderName.AUTHORITY), HpackStaticTable.newPseudoHeaderMethodField(HttpMethod.GET), HpackStaticTable.newPseudoHeaderMethodField(HttpMethod.POST), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.PATH, "/"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.PATH, "/index.html"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.SCHEME, "http"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.SCHEME, "https"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.OK.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NO_CONTENT.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.PARTIAL_CONTENT.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NOT_MODIFIED.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.BAD_REQUEST.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NOT_FOUND.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText()), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_CHARSET), HpackStaticTable.newHeaderField(HttpHeaderNames.ACCEPT_ENCODING, "gzip, deflate"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_LANGUAGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_RANGES), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.AGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ALLOW), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.AUTHORIZATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CACHE_CONTROL), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_DISPOSITION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_ENCODING), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LANGUAGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LENGTH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LOCATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_TYPE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.COOKIE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.DATE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ETAG), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.EXPECT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.EXPIRES), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.FROM), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.HOST), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_MATCH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_MODIFIED_SINCE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_NONE_MATCH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_UNMODIFIED_SINCE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.LAST_MODIFIED), HpackStaticTable.newEmptyHeaderField("link"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.LOCATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.MAX_FORWARDS), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.PROXY_AUTHENTICATE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.PROXY_AUTHORIZATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.REFERER), HpackStaticTable.newEmptyHeaderField("refresh"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.RETRY_AFTER), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.SERVER), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.SET_COOKIE), HpackStaticTable.newEmptyHeaderField("strict-transport-security"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.TRANSFER_ENCODING), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.USER_AGENT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.VARY), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.VIA), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.WWW_AUTHENTICATE));
        HEADER_NAMES_TABLE_SHIFT = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? 22 : 18;
        HEADER_NAMES = new HeaderNameIndex[512];
        for (n2 = STATIC_TABLE.size(); n2 > 0; --n2) {
            hpackHeaderField = HpackStaticTable.getEntry(n2);
            n = HpackStaticTable.headerNameBucket(hpackHeaderField.name);
            object = HEADER_NAMES[n];
            if (object != null && !HpackUtil.equalsVariableTime(((HeaderNameIndex)object).name, hpackHeaderField.name)) {
                throw new IllegalStateException("Hash bucket collision between " + ((HeaderNameIndex)object).name + " and " + hpackHeaderField.name);
            }
            HpackStaticTable.HEADER_NAMES[n] = new HeaderNameIndex(hpackHeaderField.name, n2, hpackHeaderField.value.length() == 0);
        }
        HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? 0 : 6;
        HEADERS_WITH_NON_EMPTY_VALUES = new HeaderIndex[64];
        for (n2 = STATIC_TABLE.size(); n2 > 0; --n2) {
            hpackHeaderField = HpackStaticTable.getEntry(n2);
            if (hpackHeaderField.value.length() <= 0) continue;
            n = HpackStaticTable.headerBucket(hpackHeaderField.value);
            object = HEADERS_WITH_NON_EMPTY_VALUES[n];
            if (object != null) {
                throw new IllegalStateException("Hash bucket collision between " + ((HeaderIndex)object).value + " and " + hpackHeaderField.value);
            }
            HpackStaticTable.HEADERS_WITH_NON_EMPTY_VALUES[n] = new HeaderIndex(hpackHeaderField.name, hpackHeaderField.value, n2);
        }
        length = STATIC_TABLE.size();
    }

    private static final class HeaderIndex {
        final CharSequence name;
        final CharSequence value;
        final int index;

        HeaderIndex(CharSequence charSequence, CharSequence charSequence2, int n) {
            this.name = charSequence;
            this.value = charSequence2;
            this.index = n;
        }
    }

    private static final class HeaderNameIndex {
        final CharSequence name;
        final int index;
        final boolean emptyValue;

        HeaderNameIndex(CharSequence charSequence, int n, boolean bl) {
            this.name = charSequence;
            this.index = n;
            this.emptyValue = bl;
        }
    }
}

