/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.net.ssl.SSLException;

public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            Http2MultiplexHandler.registerDone(channelFuture);
        }
    };
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    public Http2MultiplexHandler(ChannelHandler channelHandler) {
        this(channelHandler, null);
    }

    public Http2MultiplexHandler(ChannelHandler channelHandler, ChannelHandler channelHandler2) {
        this.inboundStreamHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)channelHandler, (String)"inboundStreamHandler");
        this.upgradeStreamHandler = channelHandler2;
    }

    static void registerDone(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            Channel channel = channelFuture.channel();
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
    }

    @Override
    protected void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.readCompletePendingQueue.clear();
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        if (object instanceof Http2StreamFrame) {
            if (object instanceof Http2WindowUpdateFrame) {
                return;
            }
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)object;
            Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream = (Http2FrameCodec.DefaultHttp2FrameStream)http2StreamFrame.stream();
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
            if (object instanceof Http2ResetFrame || object instanceof Http2PriorityFrame) {
                abstractHttp2StreamChannel.pipeline().fireUserEventTriggered(object);
            } else {
                abstractHttp2StreamChannel.fireChildRead(http2StreamFrame);
            }
            return;
        }
        if (object instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object);
        }
        channelHandlerContext.fireChannelRead(object);
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof Http2FrameStreamEvent) {
            Http2FrameStreamEvent http2FrameStreamEvent = (Http2FrameStreamEvent)object;
            Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream = (Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStreamEvent.stream();
            if (http2FrameStreamEvent.type() == Http2FrameStreamEvent.Type.State) {
                switch (defaultHttp2FrameStream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (defaultHttp2FrameStream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        Http2MultiplexHandlerStreamChannel http2MultiplexHandlerStreamChannel;
                        if (defaultHttp2FrameStream.attachment != null) break;
                        if (defaultHttp2FrameStream.id() == 1 && !Http2MultiplexHandler.isServer(channelHandlerContext)) {
                            if (this.upgradeStreamHandler == null) {
                                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
                            }
                            http2MultiplexHandlerStreamChannel = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.upgradeStreamHandler);
                            http2MultiplexHandlerStreamChannel.closeOutbound();
                        } else {
                            http2MultiplexHandlerStreamChannel = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.inboundStreamHandler);
                        }
                        ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register((Channel)http2MultiplexHandlerStreamChannel);
                        if (channelFuture.isDone()) {
                            Http2MultiplexHandler.registerDone(channelFuture);
                            break;
                        }
                        channelFuture.addListener((GenericFutureListener)CHILD_CHANNEL_REGISTRATION_LISTENER);
                        break;
                    }
                    case CLOSED: {
                        AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
                        if (abstractHttp2StreamChannel == null) break;
                        abstractHttp2StreamChannel.streamClosed();
                        break;
                    }
                }
            }
            return;
        }
        if (object == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (object == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (object == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    Http2StreamChannel newOutboundStream() {
        return new Http2MultiplexHandlerStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)this.newStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof Http2FrameStreamException) {
            Http2FrameStreamException http2FrameStreamException = (Http2FrameStreamException)throwable;
            Http2FrameStream http2FrameStream = http2FrameStreamException.stream();
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
            try {
                abstractHttp2StreamChannel.pipeline().fireExceptionCaught(throwable.getCause());
            }
            finally {
                abstractHttp2StreamChannel.closeWithError(http2FrameStreamException.error());
            }
            return;
        }
        if (throwable instanceof Http2MultiplexActiveStreamsException) {
            this.fireExceptionCaughtForActiveStream(throwable.getCause());
            return;
        }
        if (throwable.getCause() instanceof SSLException) {
            this.fireExceptionCaughtForActiveStream(throwable);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    private void fireExceptionCaughtForActiveStream(final Throwable throwable) {
        this.forEachActiveStream(new Http2FrameStreamVisitor(){

            @Override
            public boolean visit(Http2FrameStream http2FrameStream) {
                AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
                abstractHttp2StreamChannel.pipeline().fireExceptionCaught(throwable);
                return true;
            }
        });
    }

    private static boolean isServer(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.channel().parent() instanceof ServerChannel;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, final Http2GoAwayFrame http2GoAwayFrame) {
        if (http2GoAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            final boolean bl = Http2MultiplexHandler.isServer(channelHandlerContext);
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                @Override
                public boolean visit(Http2FrameStream http2FrameStream) {
                    int n = http2FrameStream.id();
                    if (n > http2GoAwayFrame.lastStreamId() && Http2CodecUtil.isStreamIdValid(n, bl)) {
                        AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
                        abstractHttp2StreamChannel.pipeline().fireUserEventTriggered((Object)http2GoAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught((Throwable)http2Exception);
            channelHandlerContext.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        channelHandlerContext.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this.readCompletePendingQueue.poll();
        if (abstractHttp2StreamChannel != null) {
            try {
                do {
                    abstractHttp2StreamChannel.fireChildReadComplete();
                } while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    private final class Http2MultiplexHandlerStreamChannel
    extends AbstractHttp2StreamChannel {
        Http2MultiplexHandlerStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelHandler channelHandler) {
            super(defaultHttp2FrameStream, ++Http2MultiplexHandler.this.idCount, channelHandler);
        }

        @Override
        protected boolean isParentReadInProgress() {
            return Http2MultiplexHandler.this.parentReadInProgress;
        }

        @Override
        protected void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexHandler.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexHandler.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected ChannelHandlerContext parentContext() {
            return Http2MultiplexHandler.this.ctx;
        }
    }
}

