/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;

@ChannelHandler.Sharable
public class Http2StreamFrameToHttpObjectCodec
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private static final AttributeKey<HttpScheme> SCHEME_ATTR_KEY = AttributeKey.valueOf(HttpScheme.class, (String)"STREAMFRAMECODEC_SCHEME");
    private final boolean isServer;
    private final boolean validateHeaders;

    public Http2StreamFrameToHttpObjectCodec(boolean bl, boolean bl2) {
        this.isServer = bl;
        this.validateHeaders = bl2;
    }

    public Http2StreamFrameToHttpObjectCodec(boolean bl) {
        this(bl, true);
    }

    public boolean acceptInboundMessage(Object object) {
        return object instanceof Http2HeadersFrame || object instanceof Http2DataFrame;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, Http2StreamFrame http2StreamFrame, List<Object> list) {
        if (http2StreamFrame instanceof Http2HeadersFrame) {
            Http2HeadersFrame http2HeadersFrame = (Http2HeadersFrame)http2StreamFrame;
            Http2Headers http2Headers = http2HeadersFrame.headers();
            Http2FrameStream http2FrameStream = http2HeadersFrame.stream();
            int n = http2FrameStream == null ? 0 : http2FrameStream.id();
            CharSequence charSequence = http2Headers.status();
            if (null != charSequence && Http2StreamFrameToHttpObjectCodec.isInformationalResponseHeaderFrame(charSequence)) {
                FullHttpMessage fullHttpMessage = this.newFullMessage(n, http2Headers, channelHandlerContext.alloc());
                list.add(fullHttpMessage);
                return;
            }
            if (http2HeadersFrame.isEndStream()) {
                if (http2Headers.method() == null && charSequence == null) {
                    DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, defaultLastHttpContent.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    list.add(defaultLastHttpContent);
                } else {
                    FullHttpMessage fullHttpMessage = this.newFullMessage(n, http2Headers, channelHandlerContext.alloc());
                    list.add(fullHttpMessage);
                }
            } else {
                HttpMessage httpMessage = this.newMessage(n, http2Headers);
                if (!(charSequence != null && Http2StreamFrameToHttpObjectCodec.isContentAlwaysEmpty(charSequence) || HttpUtil.isContentLengthSet((HttpMessage)httpMessage))) {
                    httpMessage.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                list.add(httpMessage);
            }
        } else if (http2StreamFrame instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)http2StreamFrame;
            if (http2DataFrame.isEndStream()) {
                list.add(new DefaultLastHttpContent(http2DataFrame.content().retain(), this.validateHeaders));
            } else {
                list.add(new DefaultHttpContent(http2DataFrame.content().retain()));
            }
        }
    }

    private void encodeLastContent(LastHttpContent lastHttpContent, List<Object> list) {
        boolean bl;
        boolean bl2 = bl = !(lastHttpContent instanceof FullHttpMessage) && lastHttpContent.trailingHeaders().isEmpty();
        if (lastHttpContent.content().isReadable() || bl) {
            list.add(new DefaultHttp2DataFrame(lastHttpContent.content().retain(), lastHttpContent.trailingHeaders().isEmpty()));
        }
        if (!lastHttpContent.trailingHeaders().isEmpty()) {
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(lastHttpContent.trailingHeaders(), this.validateHeaders);
            list.add(new DefaultHttp2HeadersFrame(http2Headers, true));
        }
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        Object object;
        if (httpObject instanceof HttpResponse) {
            object = (HttpResponse)httpObject;
            HttpResponseStatus httpResponseStatus = object.status();
            int n = httpResponseStatus.code();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL && n != 101) {
                if (object instanceof FullHttpResponse) {
                    Http2Headers http2Headers = this.toHttp2Headers(channelHandlerContext, (HttpMessage)object);
                    list.add(new DefaultHttp2HeadersFrame(http2Headers, false));
                    return;
                }
                throw new EncoderException(httpResponseStatus + " must be a FullHttpResponse");
            }
        }
        if (httpObject instanceof HttpMessage) {
            object = this.toHttp2Headers(channelHandlerContext, (HttpMessage)httpObject);
            boolean bl = false;
            if (httpObject instanceof FullHttpMessage) {
                FullHttpMessage fullHttpMessage = (FullHttpMessage)httpObject;
                bl = !fullHttpMessage.content().isReadable() && fullHttpMessage.trailingHeaders().isEmpty();
            }
            list.add(new DefaultHttp2HeadersFrame((Http2Headers)object, bl));
        }
        if (httpObject instanceof LastHttpContent) {
            object = (LastHttpContent)httpObject;
            this.encodeLastContent((LastHttpContent)object, list);
        } else if (httpObject instanceof HttpContent) {
            object = (HttpContent)httpObject;
            list.add(new DefaultHttp2DataFrame(object.content().retain(), false));
        }
    }

    private Http2Headers toHttp2Headers(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            httpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)Http2StreamFrameToHttpObjectCodec.connectionScheme(channelHandlerContext));
        }
        return HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
    }

    private HttpMessage newMessage(int n, Http2Headers http2Headers) {
        return this.isServer ? HttpConversionUtil.toHttpRequest(n, http2Headers, this.validateHeaders) : HttpConversionUtil.toHttpResponse(n, http2Headers, this.validateHeaders);
    }

    private FullHttpMessage newFullMessage(int n, Http2Headers http2Headers, ByteBufAllocator byteBufAllocator) {
        return this.isServer ? HttpConversionUtil.toFullHttpRequest(n, http2Headers, byteBufAllocator, this.validateHeaders) : HttpConversionUtil.toFullHttpResponse(n, http2Headers, byteBufAllocator, this.validateHeaders);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        Attribute<HttpScheme> attribute = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext);
        if (attribute.get() == null) {
            HttpScheme httpScheme = this.isSsl(channelHandlerContext) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            attribute.set((Object)httpScheme);
        }
    }

    protected boolean isSsl(ChannelHandlerContext channelHandlerContext) {
        Channel channel = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext);
        return null != channel.pipeline().get(SslHandler.class);
    }

    private static HttpScheme connectionScheme(ChannelHandlerContext channelHandlerContext) {
        HttpScheme httpScheme = (HttpScheme)Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext).get();
        return httpScheme == null ? HttpScheme.HTTP : httpScheme;
    }

    private static Attribute<HttpScheme> connectionSchemeAttribute(ChannelHandlerContext channelHandlerContext) {
        Channel channel = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext);
        return channel.attr(SCHEME_ATTR_KEY);
    }

    private static Channel connectionChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        return channel instanceof Http2StreamChannel ? channel.parent() : channel;
    }

    private static boolean isInformationalResponseHeaderFrame(CharSequence charSequence) {
        if (charSequence.length() == 3) {
            char c = charSequence.charAt(0);
            char c2 = charSequence.charAt(1);
            char c3 = charSequence.charAt(2);
            return c == '1' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c3 != '1';
        }
        return false;
    }

    private static boolean isContentAlwaysEmpty(CharSequence charSequence) {
        if (charSequence.length() == 3) {
            char c = charSequence.charAt(0);
            char c2 = charSequence.charAt(1);
            char c3 = charSequence.charAt(2);
            return (c == '2' || c == '3') && c2 == '0' && c3 == '4';
        }
        return false;
    }
}

