/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.content;

import io.ktor.client.call.UnsupportedContentTypeException;
import io.ktor.client.content.ProgressListener;
import io.ktor.client.utils.ByteChannelUtilsKt;
import io.ktor.http.ContentType;
import io.ktor.http.Headers;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.WriterScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0011\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u000e*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J1\u0010\u0015\u001a\u00020\u0014\"\b\b\u0000\u0010\u000e*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010!\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010%\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010)\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010-\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lio/ktor/client/content/ObservableContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Lio/ktor/http/content/OutgoingContent;", "delegate", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Lio/ktor/client/content/ProgressListener;", "listener", "<init>", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/CoroutineContext;Lio/ktor/client/content/ProgressListener;)V", "Lio/ktor/utils/io/ByteReadChannel;", "getContent", "(Lio/ktor/http/content/OutgoingContent;)Lio/ktor/utils/io/ByteReadChannel;", "", "T", "Lio/ktor/util/AttributeKey;", "key", "getProperty", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "value", "", "setProperty", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Lio/ktor/http/content/OutgoingContent;", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/client/content/ProgressListener;", "content", "Lio/ktor/utils/io/ByteReadChannel;", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "contentType", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "status", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers", "ktor-client-core"})
public final class ObservableContent
extends OutgoingContent.ReadChannelContent {
    private final OutgoingContent delegate;
    private final CoroutineContext callContext;
    private final ProgressListener listener;
    private final ByteReadChannel content;

    public ObservableContent(OutgoingContent outgoingContent, CoroutineContext coroutineContext, ProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)outgoingContent, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"");
        this.delegate = outgoingContent;
        this.callContext = coroutineContext;
        this.listener = progressListener;
        this.content = this.getContent(this.delegate);
    }

    private final ByteReadChannel getContent(OutgoingContent outgoingContent) {
        ByteReadChannel byteReadChannel;
        OutgoingContent outgoingContent2 = outgoingContent;
        if (outgoingContent2 instanceof OutgoingContent.ContentWrapper) {
            byteReadChannel = this.getContent(((OutgoingContent.ContentWrapper)outgoingContent).delegate());
        } else if (outgoingContent2 instanceof OutgoingContent.ByteArrayContent) {
            byteReadChannel = ByteChannelCtorKt.ByteReadChannel$default((byte[])((OutgoingContent.ByteArrayContent)outgoingContent).bytes(), (int)0, (int)0, (int)6, null);
        } else {
            if (outgoingContent2 instanceof OutgoingContent.ProtocolUpgrade) {
                throw new UnsupportedContentTypeException(outgoingContent);
            }
            if (outgoingContent2 instanceof OutgoingContent.NoContent) {
                byteReadChannel = ByteReadChannel.Companion.getEmpty();
            } else if (outgoingContent2 instanceof OutgoingContent.ReadChannelContent) {
                byteReadChannel = ((OutgoingContent.ReadChannelContent)outgoingContent).readFrom();
            } else if (outgoingContent2 instanceof OutgoingContent.WriteChannelContent) {
                byteReadChannel = ByteWriteChannelOperationsKt.writer((CoroutineScope)((CoroutineScope)ap.a), (CoroutineContext)this.callContext, (boolean)true, (Function2)((Function2)new Function2<WriterScope, Continuation<? super Unit>, Object>(outgoingContent, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ OutgoingContent $delegate;
                    {
                        this.$delegate = outgoingContent;
                        super(2, continuation);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                WriterScope writerScope = (WriterScope)this.L$0;
                                this.label = 1;
                                Object object3 = ((OutgoingContent.WriteChannelContent)this.$delegate).writeTo(writerScope.getChannel(), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)object);
                                Object object3 = object;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                        Function2<WriterScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = object;
                        return (Continuation)function2;
                    }

                    public final Object invoke(WriterScope writerScope, Continuation<? super Unit> continuation) {
                        return (this.create(writerScope, continuation)).invokeSuspend(Unit.INSTANCE);
                    }
                })).getChannel();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byteReadChannel;
    }

    public ContentType getContentType() {
        return this.delegate.getContentType();
    }

    public Long getContentLength() {
        return this.delegate.getContentLength();
    }

    public HttpStatusCode getStatus() {
        return this.delegate.getStatus();
    }

    public Headers getHeaders() {
        return this.delegate.getHeaders();
    }

    public <T> T getProperty(AttributeKey<T> attributeKey) {
        Intrinsics.checkNotNullParameter(attributeKey, (String)"");
        return (T)this.delegate.getProperty(attributeKey);
    }

    public <T> void setProperty(AttributeKey<T> attributeKey, T t) {
        Intrinsics.checkNotNullParameter(attributeKey, (String)"");
        this.delegate.setProperty(attributeKey, t);
    }

    public ByteReadChannel readFrom() {
        return ByteChannelUtilsKt.observable(this.content, this.callContext, this.getContentLength(), this.listener);
    }
}

