/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.SkiaBackedPathMeasure_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010Q\u001a\u00020RH\u0002J\b\u0010S\u001a\u00020RH\u0002J\f\u0010T\u001a\u00020R*\u00020UH\u0016J\b\u0010V\u001a\u00020\u0005H\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R$\u0010(\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R(\u0010+\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u000e\"\u0004\b-\u0010\u0010R&\u0010/\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b0\u0010!\"\u0004\b1\u0010#R&\u00103\u001a\u0002022\u0006\u0010\u0004\u001a\u000202@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b4\u0010!\"\u0004\b5\u0010#R$\u00106\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0014\"\u0004\b8\u0010\u0016R$\u00109\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0014\"\u0004\b;\u0010\u0016R$\u0010<\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0014\"\u0004\b>\u0010\u0016R$\u0010?\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0014\"\u0004\bA\u0010\u0016R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010K\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bM\u0010N\u00a8\u0006W"}, d2={"Landroidx/compose/ui/graphics/vector/PathComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "<init>", "()V", "value", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "Landroidx/compose/ui/graphics/Brush;", "fill", "getFill", "()Landroidx/compose/ui/graphics/Brush;", "setFill", "(Landroidx/compose/ui/graphics/Brush;)V", "", "fillAlpha", "getFillAlpha", "()F", "setFillAlpha", "(F)V", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "pathData", "getPathData", "()Ljava/util/List;", "setPathData", "(Ljava/util/List;)V", "Landroidx/compose/ui/graphics/PathFillType;", "pathFillType", "getPathFillType-Rg-k1Os", "()I", "setPathFillType-oQ8Xj4U", "(I)V", "I", "strokeAlpha", "getStrokeAlpha", "setStrokeAlpha", "strokeLineWidth", "getStrokeLineWidth", "setStrokeLineWidth", "stroke", "getStroke", "setStroke", "Landroidx/compose/ui/graphics/StrokeCap;", "strokeLineCap", "getStrokeLineCap-KaPHkGw", "setStrokeLineCap-BeK7IIE", "Landroidx/compose/ui/graphics/StrokeJoin;", "strokeLineJoin", "getStrokeLineJoin-LxFBmk8", "setStrokeLineJoin-Ww9F2mQ", "strokeLineMiter", "getStrokeLineMiter", "setStrokeLineMiter", "trimPathStart", "getTrimPathStart", "setTrimPathStart", "trimPathEnd", "getTrimPathEnd", "setTrimPathEnd", "trimPathOffset", "getTrimPathOffset", "setTrimPathOffset", "isPathDirty", "", "isStrokeDirty", "isTrimPathDirty", "strokeStyle", "Landroidx/compose/ui/graphics/drawscope/Stroke;", "path", "Landroidx/compose/ui/graphics/Path;", "renderPath", "pathMeasure", "Landroidx/compose/ui/graphics/PathMeasure;", "getPathMeasure", "()Landroidx/compose/ui/graphics/PathMeasure;", "pathMeasure$delegate", "Lkotlin/Lazy;", "updatePath", "", "updateRenderPath", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "toString", "ui"})
public final class PathComponent
extends VNode {
    private String name = "";
    private Brush fill;
    private float fillAlpha = 1.0f;
    private List<? extends PathNode> pathData = VectorKt.getEmptyPath();
    private int pathFillType = VectorKt.getDefaultFillType();
    private float strokeAlpha = 1.0f;
    private float strokeLineWidth;
    private Brush stroke;
    private int strokeLineCap = VectorKt.getDefaultStrokeLineCap();
    private int strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
    private float strokeLineMiter = 4.0f;
    private float trimPathStart;
    private float trimPathEnd = 1.0f;
    private float trimPathOffset;
    private boolean isPathDirty = true;
    private boolean isStrokeDirty = true;
    private boolean isTrimPathDirty;
    private Stroke strokeStyle;
    private final Path path;
    private Path renderPath = this.path = SkiaBackedPath_skikoKt.Path();
    private final Lazy pathMeasure$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, PathComponent::pathMeasure_delegate$lambda$0);
    public static final int $stable = 8;

    public PathComponent() {
        super(null);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.name = string;
        this.invalidate();
    }

    public final Brush getFill() {
        return this.fill;
    }

    public final void setFill(Brush brush) {
        this.fill = brush;
        this.invalidate();
    }

    public final float getFillAlpha() {
        return this.fillAlpha;
    }

    public final void setFillAlpha(float f2) {
        this.fillAlpha = f2;
        this.invalidate();
    }

    public final List<PathNode> getPathData() {
        return this.pathData;
    }

    public final void setPathData(List<? extends PathNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.pathData = list;
        this.isPathDirty = true;
        this.invalidate();
    }

    public final int getPathFillType-Rg-k1Os() {
        return this.pathFillType;
    }

    public final void setPathFillType-oQ8Xj4U(int n) {
        this.pathFillType = n;
        this.renderPath.setFillType-oQ8Xj4U(n);
        this.invalidate();
    }

    public final float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public final void setStrokeAlpha(float f2) {
        this.strokeAlpha = f2;
        this.invalidate();
    }

    public final float getStrokeLineWidth() {
        return this.strokeLineWidth;
    }

    public final void setStrokeLineWidth(float f2) {
        this.strokeLineWidth = f2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final Brush getStroke() {
        return this.stroke;
    }

    public final void setStroke(Brush brush) {
        this.stroke = brush;
        this.invalidate();
    }

    public final int getStrokeLineCap-KaPHkGw() {
        return this.strokeLineCap;
    }

    public final void setStrokeLineCap-BeK7IIE(int n) {
        this.strokeLineCap = n;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final int getStrokeLineJoin-LxFBmk8() {
        return this.strokeLineJoin;
    }

    public final void setStrokeLineJoin-Ww9F2mQ(int n) {
        this.strokeLineJoin = n;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final float getStrokeLineMiter() {
        return this.strokeLineMiter;
    }

    public final void setStrokeLineMiter(float f2) {
        this.strokeLineMiter = f2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final float getTrimPathStart() {
        return this.trimPathStart;
    }

    public final void setTrimPathStart(float f2) {
        this.trimPathStart = f2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    public final float getTrimPathEnd() {
        return this.trimPathEnd;
    }

    public final void setTrimPathEnd(float f2) {
        this.trimPathEnd = f2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    public final float getTrimPathOffset() {
        return this.trimPathOffset;
    }

    public final void setTrimPathOffset(float f2) {
        this.trimPathOffset = f2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    private final PathMeasure getPathMeasure() {
        Lazy lazy = this.pathMeasure$delegate;
        return (PathMeasure)lazy.getValue();
    }

    private final void updatePath() {
        PathParserKt.toPath(this.pathData, (Path)this.path);
        this.updateRenderPath();
    }

    private final void updateRenderPath() {
        if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f) {
            this.renderPath = this.path;
        } else {
            boolean bl;
            if (Intrinsics.areEqual((Object)this.renderPath, (Object)this.path)) {
                this.renderPath = SkiaBackedPath_skikoKt.Path();
            } else {
                int n = this.renderPath.getFillType-Rg-k1Os();
                this.renderPath.rewind();
                this.renderPath.setFillType-oQ8Xj4U(n);
            }
            this.getPathMeasure().setPath(this.path, false);
            float f2 = this.getPathMeasure().getLength();
            float f3 = (this.trimPathStart + this.trimPathOffset) % 1.0f * f2;
            float f4 = (this.trimPathEnd + this.trimPathOffset) % 1.0f * f2;
            if (f3 > f4) {
                this.getPathMeasure().getSegment(f3, f2, this.renderPath, true);
                bl = this.getPathMeasure().getSegment(0.0f, f4, this.renderPath, true);
            } else {
                bl = this.getPathMeasure().getSegment(f3, f4, this.renderPath, true);
            }
        }
    }

    @Override
    public void draw(DrawScope drawScope) {
        block5: {
            boolean bl;
            Brush brush;
            Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
            if (this.isPathDirty) {
                this.updatePath();
            } else if (this.isTrimPathDirty) {
                this.updateRenderPath();
            }
            this.isPathDirty = false;
            this.isTrimPathDirty = false;
            Brush brush2 = this.fill;
            if (brush2 != null) {
                brush = brush2;
                bl = false;
                DrawScope.drawPath-GBMwjPU$default((DrawScope)drawScope, (Path)this.renderPath, (Brush)brush, (float)this.fillAlpha, null, null, (int)0, (int)56, null);
            }
            Brush brush3 = this.stroke;
            if (brush3 == null) break block5;
            brush = brush3;
            bl = false;
            Stroke stroke = this.strokeStyle;
            if (this.isStrokeDirty || stroke == null) {
                this.strokeStyle = stroke = new Stroke(this.strokeLineWidth, this.strokeLineMiter, this.strokeLineCap, this.strokeLineJoin, null, 16, null);
                this.isStrokeDirty = false;
            }
            DrawScope.drawPath-GBMwjPU$default((DrawScope)drawScope, (Path)this.renderPath, (Brush)brush, (float)this.strokeAlpha, (DrawStyle)((DrawStyle)stroke), null, (int)0, (int)48, null);
        }
    }

    public String toString() {
        return this.path.toString();
    }

    private static final PathMeasure pathMeasure_delegate$lambda$0() {
        return SkiaBackedPathMeasure_skikoKt.PathMeasure();
    }
}

