/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.b.O;
import androidx.b.Y;
import androidx.b.Z;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessible;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.J;
import kotlinx.coroutines.aw;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.i;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u00002\u00020\u0001:\u00016B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010(\u001a\u00020\tJ\u000e\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020\tH\u0002J\u0006\u0010.\u001a\u00020\tJ\u000e\u0010/\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Landroidx/compose/ui/platform/a11y/AccessibilityController;", "", "owner", "Landroidx/compose/ui/semantics/SemanticsOwner;", "desktopComponent", "Landroidx/compose/ui/platform/PlatformComponent;", "onFocusReceived", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "", "<init>", "(Landroidx/compose/ui/semantics/SemanticsOwner;Landroidx/compose/ui/platform/PlatformComponent;Lkotlin/jvm/functions/Function1;)V", "getOwner", "()Landroidx/compose/ui/semantics/SemanticsOwner;", "getDesktopComponent", "()Landroidx/compose/ui/platform/PlatformComponent;", "accessibleByNodeId", "Landroidx/collection/MutableScatterMap;", "", "nodeMappingIsValid", "", "nodeId", "onNodeAdded", "accessible", "onNodeRemoved", "onNodeChanged", "component", "previousSemanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "newSemanticsNode", "nodeSyncChannel", "Lkotlinx/coroutines/channels/Channel;", "bfsDeque", "Lkotlin/collections/ArrayDeque;", "auxAccessibleByNodeId", "delayedNodeNotifications", "", "Lkotlin/Function0;", "syncingJob", "Lkotlinx/coroutines/Job;", "dispose", "launchSyncLoop", "context", "Lkotlin/coroutines/CoroutineContext;", "syncNodes", "scheduleNodeSyncIfNeeded", "onSemanticsChange", "onLayoutChanged", "rootSemanticNode", "getRootSemanticNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "rootAccessible", "getRootAccessible", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "AccessibilityUsage", "ui"})
public final class AccessibilityController {
    private final SemanticsOwner owner;
    private final PlatformComponent desktopComponent;
    private final Function1<ComposeAccessible, Unit> onFocusReceived;
    private O<Integer, ComposeAccessible> accessibleByNodeId;
    private boolean nodeMappingIsValid;
    private final Channel<Unit> nodeSyncChannel;
    private final ArrayDeque<SemanticsNode> bfsDeque;
    private O<Integer, ComposeAccessible> auxAccessibleByNodeId;
    private final List<Function0<Unit>> delayedNodeNotifications;
    private aw syncingJob;
    public static final int $stable = 8;

    public AccessibilityController(SemanticsOwner semanticsOwner, PlatformComponent platformComponent, Function1<? super ComposeAccessible, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)semanticsOwner, (String)"");
        Intrinsics.checkNotNullParameter((Object)platformComponent, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.owner = semanticsOwner;
        this.desktopComponent = platformComponent;
        this.onFocusReceived = function1;
        this.accessibleByNodeId = Z.b();
        this.nodeSyncChannel = kotlinx.coroutines.channels.i.a((int)0, null, null, (int)6, null);
        this.bfsDeque = new ArrayDeque();
        this.auxAccessibleByNodeId = Z.b();
        this.delayedNodeNotifications = new ArrayList();
    }

    public final SemanticsOwner getOwner() {
        return this.owner;
    }

    public final PlatformComponent getDesktopComponent() {
        return this.desktopComponent;
    }

    public final ComposeAccessible accessibleByNodeId(int n2) {
        if (!this.nodeMappingIsValid) {
            this.syncNodes();
        }
        return (ComposeAccessible)this.accessibleByNodeId.c((Object)n2);
    }

    private final void onNodeAdded(ComposeAccessible composeAccessible) {
    }

    private final void onNodeRemoved(ComposeAccessible composeAccessible) {
        composeAccessible.setRemoved(true);
    }

    private final void onNodeChanged(ComposeAccessible composeAccessible, SemanticsNode semanticsNode, SemanticsNode semanticsNode2) {
        block4: for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : semanticsNode2.getConfig()) {
            Object obj = SemanticsConfigurationKt.getOrNull(semanticsNode.getConfig(), entry.getKey());
            if (Intrinsics.areEqual((Object)entry.getValue(), obj)) continue;
            SemanticsPropertyKey<?> semanticsPropertyKey = entry.getKey();
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getText())) {
                composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleText", obj, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getEditableText())) {
                composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleText", obj, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getTextSelectionRange())) {
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = composeAccessible.getComposeAccessibleContext();
                TextRange textRange = obj instanceof TextRange ? (TextRange)obj : null;
                Integer n2 = textRange != null ? Integer.valueOf(TextRange.getStart-impl((long)textRange.unbox-impl())) : null;
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object);
                composeAccessibleComponent.firePropertyChange("AccessibleCaret", n2, TextRange.getStart-impl((long)((TextRange)object).unbox-impl()));
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getFocused())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((Boolean)object).booleanValue()) {
                    composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                    this.onFocusReceived.invoke((Object)composeAccessible);
                    continue;
                }
                composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getToggleableState())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object);
                switch (WhenMappings.$EnumSwitchMapping$0[((ToggleableState)((Object)object)).ordinal()]) {
                    case 1: {
                        composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                        continue block4;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getProgressBarRangeInfo())) continue;
            Object object = entry.getValue();
            Intrinsics.checkNotNull((Object)object);
            ProgressBarRangeInfo progressBarRangeInfo = (ProgressBarRangeInfo)object;
            ProgressBarRangeInfo progressBarRangeInfo2 = obj instanceof ProgressBarRangeInfo ? (ProgressBarRangeInfo)obj : null;
            composeAccessible.getComposeAccessibleContext().firePropertyChange("AccessibleValue", progressBarRangeInfo2 != null ? Float.valueOf(progressBarRangeInfo2.getCurrent()) : null, Float.valueOf(progressBarRangeInfo.getCurrent()));
        }
    }

    public final void dispose() {
        block0: {
            aw aw2 = this.syncingJob;
            if (aw2 == null) break block0;
            aw.a.a((aw)aw2, null, (int)1, null);
        }
    }

    public final void launchSyncLoop(CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"");
        if (this.syncingJob != null) {
            throw new IllegalStateException("Sync loop already running");
        }
        this.syncingJob = i.a((CoroutineScope)J.a((CoroutineContext)coroutineContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccessibilityController this$0;
            {
                this.this$0 = accessibilityController;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = AccessibilityUsage.INSTANCE.runActiveController(this.this$0, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccessibilityController this$0;
                            {
                                this.this$0 = accessibilityController;
                                super(1, continuation);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                                        // 2 sources

                                        while (true) {
                                            this.label = 1;
                                            v0 = AccessibilityController.access$getNodeSyncChannel$p(this.this$0).a((Continuation)this);
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl15
                                            break;
                                        }
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        v0 = var1_1;
lbl15:
                                        // 2 sources

                                        AccessibilityController.access$syncNodes(this.this$0);
                                        ** continue;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> continuation) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> continuation) {
                                return (this.create(continuation)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void syncNodes() {
        Object object5;
        Object object2;
        Object object3;
        O<Integer, ComposeAccessible> o2 = this.accessibleByNodeId;
        O<Integer, ComposeAccessible> o3 = this.auxAccessibleByNodeId;
        if (AccessibilityController.syncNodes$isValid(this.getRootSemanticNode())) {
            this.bfsDeque.add((Object)this.getRootSemanticNode());
        }
        while (!((Collection)this.bfsDeque).isEmpty()) {
            Object object4;
            object3 = (SemanticsNode)this.bfsDeque.removeFirst();
            if (AccessibilityController.syncNodes$isInvisibleToA11y((SemanticsNode)object3)) continue;
            ComposeAccessible composeAccessible = (ComposeAccessible)o2.c((Object)((SemanticsNode)object3).getId());
            Integer n2 = ((SemanticsNode)object3).getId();
            if (composeAccessible != null) {
                object2 = composeAccessible.getSemanticsNode();
                composeAccessible.setSemanticsNode((SemanticsNode)object3);
                this.delayedNodeNotifications.add((Function0<Unit>)((Function0)() -> AccessibilityController.syncNodes$lambda$2(this, composeAccessible, (SemanticsNode)object2, (SemanticsNode)object3)));
                object4 = composeAccessible;
            } else {
                object2 = new ComposeAccessible((SemanticsNode)object3, this);
                this.delayedNodeNotifications.add((Function0<Unit>)((Function0)() -> AccessibilityController.syncNodes$lambda$3(this, (ComposeAccessible)object2)));
                object4 = object2;
            }
            o3.a((Object)n2, object4);
            for (Object object5 : CollectionsKt.asReversed(((SemanticsNode)object3).getReplacedChildren$ui())) {
                if (!AccessibilityController.syncNodes$isValid((SemanticsNode)object5)) continue;
                this.bfsDeque.add(object5);
            }
        }
        object3 = (Y)o2;
        boolean bl = false;
        object2 = ((Y)object3).b;
        object5 = ((Y)object3).c;
        Object object6 = object3;
        boolean bl2 = false;
        int n3 = 0;
        long[] lArray = ((Y)object6).a;
        int n4 = lArray.length - 2;
        if (n3 <= n4) {
            while (true) {
                long l2;
                long l3 = l2 = lArray[n3];
                int n5 = 0;
                if ((l3 & (l3 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int n6 = 8 - (~(n3 - n4) >>> 31);
                    for (int j = 0; j < n6; ++j) {
                        long l4 = l2 & 0xFFL;
                        boolean bl3 = false;
                        if (l4 < 128L) {
                            int n7 = n5 = (n3 << 3) + j;
                            boolean bl4 = false;
                            ComposeAccessible composeAccessible = (ComposeAccessible)object5[n7];
                            int n8 = ((Number)object2[n7]).intValue();
                            boolean bl5 = false;
                            if (!o3.d((Object)n8)) {
                                this.delayedNodeNotifications.add((Function0<Unit>)((Function0)() -> AccessibilityController.syncNodes$lambda$5$lambda$4(this, composeAccessible)));
                            }
                        }
                        l2 >>= 8;
                    }
                    if (n6 != 8) break;
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        Object object72 = object3 = o2;
        AccessibilityController accessibilityController = this;
        boolean bl6 = false;
        object72.a();
        accessibilityController.auxAccessibleByNodeId = object3;
        this.accessibleByNodeId = o3;
        this.nodeMappingIsValid = true;
        for (Function0 function0 : this.delayedNodeNotifications) {
            function0.invoke();
        }
        this.delayedNodeNotifications.clear();
    }

    private final void scheduleNodeSyncIfNeeded() {
        if (AccessibilityUsage.INSTANCE.getRecentlyUsed() && !this.nodeMappingIsValid) {
            this.nodeSyncChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }
    }

    public final void onSemanticsChange() {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    public final void onLayoutChanged(int n2) {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    private final SemanticsNode getRootSemanticNode() {
        return this.owner.getRootSemanticsNode();
    }

    public final ComposeAccessible getRootAccessible() {
        ComposeAccessible composeAccessible = this.accessibleByNodeId(this.getRootSemanticNode().getId());
        Intrinsics.checkNotNull((Object)composeAccessible);
        return composeAccessible;
    }

    private static final boolean syncNodes$isValid(SemanticsNode semanticsNode) {
        LayoutNode layoutNode = semanticsNode.getLayoutNode$ui();
        boolean bl = false;
        return layoutNode.isPlaced() && layoutNode.isAttached();
    }

    private static final boolean syncNodes$isInvisibleToA11y(SemanticsNode semanticsNode) {
        SemanticsConfiguration semanticsConfiguration = semanticsNode.getConfig();
        boolean bl = false;
        return semanticsConfiguration.contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) || semanticsConfiguration.contains(SemanticsProperties.INSTANCE.getHideFromAccessibility());
    }

    private static final Unit syncNodes$lambda$2(AccessibilityController accessibilityController, ComposeAccessible composeAccessible, SemanticsNode semanticsNode, SemanticsNode semanticsNode2) {
        accessibilityController.onNodeChanged(composeAccessible, semanticsNode, semanticsNode2);
        return Unit.INSTANCE;
    }

    private static final Unit syncNodes$lambda$3(AccessibilityController accessibilityController, ComposeAccessible composeAccessible) {
        accessibilityController.onNodeAdded(composeAccessible);
        return Unit.INSTANCE;
    }

    private static final Unit syncNodes$lambda$5$lambda$4(AccessibilityController accessibilityController, ComposeAccessible composeAccessible) {
        accessibilityController.onNodeRemoved(composeAccessible);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Channel access$getNodeSyncChannel$p(AccessibilityController accessibilityController) {
        return accessibilityController.nodeSyncChannel;
    }

    public static final /* synthetic */ void access$syncNodes(AccessibilityController accessibilityController) {
        accessibilityController.syncNodes();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0006\u0010\r\u001a\u00020\u000bJ4\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\b2\u001c\u0010\u0014\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/platform/a11y/AccessibilityController$AccessibilityUsage;", "", "<init>", "()V", "MaxIdleTimeNanos", "", "activeControllers", "", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "lastUseTimeNanos", "reset", "", "reset$ui", "notifyInUse", "recentlyUsed", "", "getRecentlyUsed", "()Z", "runActiveController", "controller", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Landroidx/compose/ui/platform/a11y/AccessibilityController;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ui"})
    public static final class AccessibilityUsage {
        public static final AccessibilityUsage INSTANCE = new AccessibilityUsage();
        private static final long MaxIdleTimeNanos = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        private static final Set<AccessibilityController> activeControllers = new LinkedHashSet();
        private static long lastUseTimeNanos = System.nanoTime() - (MaxIdleTimeNanos + 1L);
        public static final int $stable = 8;

        private AccessibilityUsage() {
        }

        public final void reset$ui() {
            boolean bl = activeControllers.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            lastUseTimeNanos = System.nanoTime() - (MaxIdleTimeNanos + 1L);
        }

        public final void notifyInUse() {
            lastUseTimeNanos = System.nanoTime();
            for (AccessibilityController accessibilityController : activeControllers) {
                accessibilityController.scheduleNodeSyncIfNeeded();
            }
        }

        public final boolean getRecentlyUsed() {
            return System.nanoTime() - lastUseTimeNanos < MaxIdleTimeNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public final Object runActiveController(AccessibilityController var1_1, Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof runActiveController.1)) ** GOTO lbl-1000
            var6_4 = var3_3;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                var6_4 = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccessibilityUsage this$0;
                    int label;
                    {
                        this.this$0 = accessibilityUsage;
                        super(continuation);
                    }

                    public final Object invokeSuspend(Object object) {
                        this.result = object;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runActiveController(null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            var5_5 = var6_4.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch (var6_4.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)var5_5);
                    AccessibilityUsage.activeControllers.add(var1_1);
                    var6_4.L$0 = var1_1;
                    var6_4.label = 1;
                    v0 = var2_2.invoke((Object)var6_4);
                    ** if (v0 != var7_6) goto lbl21
lbl20:
                    // 1 sources

                    return var7_6;
lbl21:
                    // 1 sources

                    ** GOTO lbl35
                }
                case 1: {
                    var1_1 = (AccessibilityController)var6_4.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)var5_5);
                        v0 = var5_5;
                    }
                    catch (Throwable var4_7) {
                        throw var4_7;
                    }
                    finally {
                        AccessibilityUsage.activeControllers.remove(var1_1);
                    }
lbl35:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleableState.values().length];
            try {
                nArray[ToggleableState.On.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Off.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Indeterminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

