/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.platform.InspectorInfo;
import androidx.compose.ui.platform.ValueElementSequence;
import androidx.compose.ui.semantics.AppendedSemanticsElement;
import androidx.compose.ui.semantics.ClearAndSetSemanticsElement;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a-\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e\u001a#\u0010\u000f\u001a\u00020\u0007*\u00020\u00072\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e\u001a\u0014\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0014\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"lastIdentifier", "Ljava/util/concurrent/atomic/AtomicInteger;", "Landroidx/compose/ui/platform/AtomicInt;", "Ljava/util/concurrent/atomic/AtomicInteger;", "generateSemanticsId", "", "semantics", "Landroidx/compose/ui/Modifier;", "mergeDescendants", "", "properties", "Lkotlin/Function1;", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "", "Lkotlin/ExtensionFunctionType;", "clearAndSetSemantics", "addSemanticsPropertiesFrom", "Landroidx/compose/ui/platform/InspectorInfo;", "semanticsConfiguration", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "ui"})
public final class SemanticsModifierKt {
    private static AtomicInteger lastIdentifier = new AtomicInteger(0);

    public static final int generateSemanticsId() {
        return lastIdentifier.addAndGet(1);
    }

    public static final Modifier semantics(Modifier modifier2, boolean bl, Function1<? super SemanticsPropertyReceiver, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)modifier2, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return modifier2.then(new AppendedSemanticsElement(bl, function1));
    }

    public static /* synthetic */ Modifier semantics$default(Modifier modifier2, boolean bl, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return SemanticsModifierKt.semantics(modifier2, bl, (Function1<? super SemanticsPropertyReceiver, Unit>)function1);
    }

    public static final Modifier clearAndSetSemantics(Modifier modifier2, Function1<? super SemanticsPropertyReceiver, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)modifier2, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return modifier2.then(new ClearAndSetSemanticsElement(function1));
    }

    private static final void addSemanticsPropertiesFrom(InspectorInfo inspectorInfo, SemanticsConfiguration semanticsConfiguration) {
        Iterable iterable = semanticsConfiguration;
        String string = "properties";
        ValueElementSequence valueElementSequence = inspectorInfo.getProperties();
        boolean bl = false;
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map map = new LinkedHashMap(n2);
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            Map map2 = map;
            Map.Entry entry = (Map.Entry)t2;
            boolean bl3 = false;
            SemanticsPropertyKey semanticsPropertyKey = (SemanticsPropertyKey)entry.getKey();
            Object v2 = entry.getValue();
            entry = TuplesKt.to((Object)semanticsPropertyKey.getName(), v2);
            map2.put(entry.getFirst(), entry.getSecond());
        }
        Map map3 = map;
        valueElementSequence.set(string, map3);
    }

    public static final /* synthetic */ void access$addSemanticsPropertiesFrom(InspectorInfo inspectorInfo, SemanticsConfiguration semanticsConfiguration) {
        SemanticsModifierKt.addSemanticsPropertiesFrom(inspectorInfo, semanticsConfiguration);
    }
}

