/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    public static final long DEFAULT_BUFFER_SIZE = 8192L;
    protected static String COLLISION_WITH_EARLIER_APPENDER_URL = "http://logback.qos.ch/codes.html#earlier_fa_collision";
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private FileSize bufferSize = new FileSize(8192L);

    public void setFile(String string) {
        this.fileName = string == null ? string : string.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int n = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (this.checkForFileCollisionInPreviousFileAppenders()) {
                this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
                ++n;
            } else {
                try {
                    this.openFile(this.getFile());
                }
                catch (IOException iOException) {
                    ++n;
                    this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", iOException);
                }
            }
        } else {
            ++n;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (n == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        Map<String, String> map = ContextUtil.getFilenameCollisionMap(this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        map.remove(this.getName());
    }

    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        boolean bl = false;
        if (this.fileName == null) {
            return false;
        }
        Map map = (Map)this.context.getObject("FA_FILENAMES_MAP");
        if (map == null) {
            return bl;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            bl = true;
        }
        if (this.name != null) {
            map.put(this.getName(), this.fileName);
        }
        return bl;
    }

    protected void addErrorForCollision(String string, String string2, String string3) {
        this.addError("'" + string + "' option has the same value \"" + string2 + "\" as that given for appender [" + string3 + "] defined earlier.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String string) {
        this.streamWriteLock.lock();
        try {
            File file = new File(string);
            boolean bl = FileUtil.createMissingParentDirectories(file);
            if (!bl) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFileOutputStream = new ResilientFileOutputStream(file, this.append, this.bufferSize.getSize());
            resilientFileOutputStream.setContext(this.context);
            this.setOutputStream(resilientFileOutputStream);
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean bl) {
        this.prudent = bl;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setBufferSize(FileSize fileSize) {
        this.addInfo("Setting bufferSize to [" + fileSize.toString() + "]");
        this.bufferSize = fileSize;
    }

    @Override
    protected void writeOut(E e) {
        if (this.prudent) {
            this.safeWriteOut(e);
        } else {
            super.writeOut(e);
        }
    }

    private void safeWriteOut(E e) {
        byte[] byArray = this.encoder.encode(e);
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.safeWriteBytes(byArray);
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWriteBytes(byte[] byArray) {
        ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFileOutputStream.getChannel();
        if (fileChannel == null) {
            return;
        }
        boolean bl = Thread.interrupted();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long l = fileChannel.position();
            long l2 = fileChannel.size();
            if (l2 != l) {
                fileChannel.position(l2);
            }
            this.writeByteArrayToOutputStreamWithPossibleFlush(byArray);
        }
        catch (IOException iOException) {
            resilientFileOutputStream.postIOFailure(iOException);
        }
        finally {
            this.releaseFileLock(fileLock);
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void releaseFileLock(FileLock fileLock) {
        if (fileLock != null && fileLock.isValid()) {
            try {
                fileLock.release();
            }
            catch (IOException iOException) {
                this.addError("failed to release lock", iOException);
            }
        }
    }
}

