/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.xml.sax.InputSource;

public abstract class GenericXMLConfigurator
extends ContextAwareBase {
    protected SaxEventInterpreter saxEventInterpreter;
    protected ModelInterpretationContext modelInterpretationContext;
    private RuleStore ruleStore;

    public ModelInterpretationContext getModelInterpretationContext() {
        return this.modelInterpretationContext;
    }

    public final void doConfigure(URL uRL) {
        InputStream inputStream = null;
        try {
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            this.doConfigure(inputStream, uRL.toExternalForm());
        }
        catch (IOException iOException) {
            String string = "Could not open URL [" + String.valueOf(uRL) + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string = "Could not close input stream";
                    this.addError(string, iOException);
                    throw new JoranException(string, iOException);
                }
            }
        }
    }

    public final void doConfigure(String string) {
        this.doConfigure(new File(string));
    }

    public final void doConfigure(File file) {
        FileInputStream fileInputStream = null;
        try {
            URL uRL = file.toURI().toURL();
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            fileInputStream = new FileInputStream(file);
            this.doConfigure(fileInputStream, uRL.toExternalForm());
        }
        catch (IOException iOException) {
            String string = "Could not open [" + file.getPath() + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    String string = "Could not close [" + file.getName() + "].";
                    this.addError(string, iOException);
                    throw new JoranException(string, iOException);
                }
            }
        }
    }

    public static void informContextOfURLUsedForConfiguration(Context context, URL uRL) {
        ConfigurationWatchListUtil.setMainWatchURL(context, uRL);
    }

    public final void doConfigure(InputStream inputStream) {
        this.doConfigure(new InputSource(inputStream));
    }

    public final void doConfigure(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.doConfigure(inputSource);
    }

    protected abstract void addElementSelectorAndActionAssociations(RuleStore var1);

    protected abstract void setImplicitRuleSupplier(SaxEventInterpreter var1);

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
    }

    protected ElementPath initialElementPath() {
        return new ElementPath();
    }

    protected void buildSaxEventInterpreter(List<SaxEvent> list) {
        RuleStore ruleStore = this.getRuleStore();
        this.addElementSelectorAndActionAssociations(ruleStore);
        this.saxEventInterpreter = new SaxEventInterpreter(this.context, ruleStore, this.initialElementPath(), list);
        SaxEventInterpretationContext saxEventInterpretationContext = this.saxEventInterpreter.getSaxEventInterpretationContext();
        saxEventInterpretationContext.setContext(this.context);
        this.setImplicitRuleSupplier(this.saxEventInterpreter);
    }

    public RuleStore getRuleStore() {
        if (this.ruleStore == null) {
            this.ruleStore = new SimpleRuleStore(this.context);
        }
        return this.ruleStore;
    }

    protected void buildModelInterpretationContext() {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context);
        this.addDefaultNestedComponentRegistryRules(this.modelInterpretationContext.getDefaultNestedComponentRegistry());
    }

    public final void doConfigure(InputSource inputSource) {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationStartedEvent(this));
        long l = System.currentTimeMillis();
        SaxEventRecorder saxEventRecorder = this.populateSaxEventRecorder(inputSource);
        List<SaxEvent> list = saxEventRecorder.getSaxEventList();
        if (list.isEmpty()) {
            this.addWarn("Empty sax event list");
            return;
        }
        Model model = this.buildModelFromSaxEventList(saxEventRecorder.getSaxEventList());
        if (model == null) {
            this.addError("Could not find valid configuration instructions. Exiting.");
            return;
        }
        this.sanityCheck(model);
        this.processModel(model);
        StatusUtil statusUtil = new StatusUtil(this.context);
        if (statusUtil.noXMLParsingErrorsOccurred(l)) {
            this.addInfo("Registering current configuration as safe fallback point");
            this.registerSafeConfiguration(model);
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedEvent(this));
    }

    public SaxEventRecorder populateSaxEventRecorder(InputSource inputSource) {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputSource);
        return saxEventRecorder;
    }

    public Model buildModelFromSaxEventList(List<SaxEvent> list) {
        this.buildSaxEventInterpreter(list);
        this.playSaxEvents();
        Model model = this.saxEventInterpreter.getSaxEventInterpretationContext().peekModel();
        return model;
    }

    private void playSaxEvents() {
        this.saxEventInterpreter.getEventPlayer().play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processModel(Model model) {
        this.buildModelInterpretationContext();
        this.modelInterpretationContext.setTopModel(model);
        this.modelInterpretationContext.setConfiguratorHint(this);
        DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, this.modelInterpretationContext);
        this.addModelHandlerAssociations(defaultProcessor);
        Object object = this.context.getConfigurationLock();
        synchronized (object) {
            defaultProcessor.process(model);
        }
    }

    protected void sanityCheck(Model model) {
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
    }

    public void registerSafeConfiguration(Model model) {
        this.context.putObject("SAFE_JORAN_CONFIGURATION", model);
    }

    public Model recallSafeConfiguration() {
        return (Model)this.context.getObject("SAFE_JORAN_CONFIGURATION");
    }
}

