/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    Model parentModel;
    IncludeModel includeModel;
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes) {
        String string2 = attributes.getValue(OPTIONAL_ATTR);
        this.includeModel = new IncludeModel();
        this.includeModel.setOptional(string2);
        this.fillInIncludeModelAttributes(this.includeModel, string, attributes);
        if (!saxEventInterpretationContext.isModelStackEmpty()) {
            this.parentModel = saxEventInterpretationContext.peekModel();
        }
        int n = IncludeAction.getLineNumber(saxEventInterpretationContext);
        this.includeModel.setLineNumber(n);
        saxEventInterpretationContext.pushModel(this.includeModel);
    }

    private void fillInIncludeModelAttributes(IncludeModel includeModel, String string, Attributes attributes) {
        this.includeModel.setTag(string);
        String string2 = attributes.getValue(FILE_ATTR);
        String string3 = attributes.getValue(URL_ATTR);
        String string4 = attributes.getValue(RESOURCE_ATTR);
        this.includeModel.setFile(string2);
        this.includeModel.setUrl(string3);
        this.includeModel.setResource(string4);
    }

    @Override
    public void end(SaxEventInterpretationContext saxEventInterpretationContext, String string) {
        if (this.inError) {
            return;
        }
        Model model = saxEventInterpretationContext.peekModel();
        if (model != this.includeModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.includeModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.includeModel);
            saxEventInterpretationContext.popModel();
        }
    }
}

