/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.Map;

public class AppenderRefModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public AppenderRefModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new AppenderRefModelHandler(context);
    }

    protected Class<? extends AppenderRefModel> getSupportedModelClass() {
        return AppenderRefModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        Object object = modelInterpretationContext.peekObject();
        if (!(object instanceof AppenderAttachable)) {
            this.inError = true;
            String string = "Could not find an AppenderAttachable at the top of execution stack. Near " + model.idString();
            this.addError(string);
            return;
        }
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        AppenderAttachable appenderAttachable = (AppenderAttachable)object;
        this.attachRefencedAppenders(modelInterpretationContext, appenderRefModel, appenderAttachable);
    }

    void attachRefencedAppenders(ModelInterpretationContext modelInterpretationContext, AppenderRefModel appenderRefModel, AppenderAttachable<?> appenderAttachable) {
        String string = modelInterpretationContext.subst(appenderRefModel.getRef());
        Map map = (Map)modelInterpretationContext.getObjectMap().get("APPENDER_BAG");
        Appender appender = (Appender)map.get(string);
        if (appender == null) {
            this.addError("Failed to find appender named [" + string + "]");
        } else {
            this.addInfo("Attaching appender named [" + string + "] to " + String.valueOf(appenderAttachable));
            appenderAttachable.addAppender(appender);
        }
    }
}

