/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.OptionHelper;

public class TimestampModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public TimestampModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new TimestampModelHandler(context);
    }

    protected Class<TimestampModel> getSupportedModelClass() {
        return TimestampModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        long l;
        String string;
        String string2;
        TimestampModel timestampModel = (TimestampModel)model;
        String string3 = timestampModel.getKey();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string3)) {
            this.addError("Attribute named [key] cannot be empty");
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string2 = timestampModel.getDatePattern())) {
            this.addError("Attribute named [datePattern] cannot be empty");
            this.inError = true;
        }
        if ("contextBirth".equalsIgnoreCase(string = timestampModel.getTimeReference())) {
            this.addInfo("Using context birth as time reference.");
            l = this.context.getBirthTime();
        } else {
            l = System.currentTimeMillis();
            this.addInfo("Using current interpretation time, i.e. now, as time reference.");
        }
        if (this.inError) {
            return;
        }
        String string4 = timestampModel.getScopeStr();
        ActionUtil.Scope scope = ActionUtil.stringToScope(string4);
        CachingDateFormatter cachingDateFormatter = new CachingDateFormatter(string2);
        String string5 = cachingDateFormatter.format(l);
        this.addInfo("Adding property to the context with key=\"" + string3 + "\" and value=\"" + string5 + "\" to the " + String.valueOf((Object)scope) + " scope");
        ActionUtil.setProperty(modelInterpretationContext, string3, string5, scope);
    }
}

