/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.a;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.h;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.RosterEntries;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterLoadedListener;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SuccessCallback;

public final class Roster
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final Map<XMPPConnection, Roster> INSTANCES;
    private static final StanzaFilter PRESENCE_PACKET_FILTER;
    private static final StanzaFilter OUTGOING_USER_UNAVAILABLE_PRESENCE;
    private static boolean rosterLoadedAtLoginDefault;
    private static SubscriptionMode defaultSubscriptionMode;
    public static final int INITIAL_DEFAULT_NON_ROSTER_PRESENCE_MAP_SIZE = 1024;
    private static int defaultNonRosterPresenceMapMaxSize;
    private RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<a, RosterEntry> entries = new ConcurrentHashMap<a, RosterEntry>();
    private final Set<RosterEntry> unfiledEntries = new CopyOnWriteArraySet<RosterEntry>();
    private final Set<RosterListener> rosterListeners = new LinkedHashSet<RosterListener>();
    private final Set<PresenceEventListener> presenceEventListeners = new CopyOnWriteArraySet<PresenceEventListener>();
    private final Map<a, Map<d, Presence>> presenceMap = new ConcurrentHashMap<a, Map<d, Presence>>();
    private final c<a, Map<d, Presence>> nonRosterPresenceMap = new c(defaultNonRosterPresenceMapMaxSize);
    private final Set<RosterLoadedListener> rosterLoadedListeners = new LinkedHashSet<RosterLoadedListener>();
    private final Object rosterListenersAndEntriesLock = new Object();
    private RosterState rosterState = RosterState.uninitialized;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private boolean rosterLoadedAtLogin = rosterLoadedAtLoginDefault;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private final Set<SubscribeListener> subscribeListeners = new CopyOnWriteArraySet<SubscribeListener>();
    private SubscriptionMode previousSubscriptionMode;
    private final AsyncButOrdered<a> asyncButOrdered = new AsyncButOrdered();

    public static synchronized Roster getInstanceFor(XMPPConnection xMPPConnection) {
        Roster roster = INSTANCES.get(xMPPConnection);
        if (roster == null) {
            roster = new Roster(xMPPConnection);
            INSTANCES.put(xMPPConnection, roster);
        }
        return roster;
    }

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    private Roster(final XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new RosterPushListener());
        xMPPConnection.addSyncStanzaListener((StanzaListener)this.presencePacketListener, PRESENCE_PACKET_FILTER);
        xMPPConnection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Object object;
                Presence.Type type;
                Presence presence = (Presence)stanza;
                i i2 = presence.getFrom();
                SubscribeListener.SubscribeAnswer subscribeAnswer = null;
                switch (Roster.this.subscriptionMode) {
                    case manual: {
                        type = Roster.this.subscribeListeners.iterator();
                        while (type.hasNext() && (subscribeAnswer = (object = (SubscribeListener)type.next()).processSubscribe(i2, presence)) == null) {
                        }
                        if (subscribeAnswer != null) break;
                        return;
                    }
                    case accept_all: {
                        subscribeAnswer = SubscribeListener.SubscribeAnswer.Approve;
                        break;
                    }
                    case reject_all: {
                        subscribeAnswer = SubscribeListener.SubscribeAnswer.Deny;
                    }
                }
                if (subscribeAnswer == null) {
                    return;
                }
                switch (subscribeAnswer) {
                    case ApproveAndAlsoRequestIfRequired: {
                        object = i2.n();
                        RosterUtil.askForSubscriptionIfRequired(Roster.this, (a)object);
                    }
                    case Approve: {
                        type = Presence.Type.subscribed;
                        break;
                    }
                    case Deny: {
                        type = Presence.Type.unsubscribed;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                object = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(type).to(presence.getFrom())).build();
                xMPPConnection.sendStanza((Stanza)object);
            }
        }, (StanzaFilter)PresenceTypeFilter.SUBSCRIBE);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!Roster.this.isRosterLoadedAtLogin()) {
                    return;
                }
                if (bl) {
                    return;
                }
                Roster.this.setOfflinePresencesAndResetLoaded();
                try {
                    Roster.this.reload();
                }
                catch (InterruptedException | SmackException throwable) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", throwable);
                    return;
                }
            }

            public void connectionClosed() {
                Roster.this.setOfflinePresencesAndResetLoaded();
            }
        });
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Roster.this.setOfflinePresences();
            }
        }, OUTGOING_USER_UNAVAILABLE_PRESENCE);
        if (xMPPConnection.isAuthenticated()) {
            try {
                this.reloadAndWait();
            }
            catch (InterruptedException | SmackException throwable) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", throwable);
            }
        }
    }

    private Map<d, Presence> getPresencesInternal(a a2) {
        Map map = this.presenceMap.get(a2);
        if (map == null) {
            map = (Map)this.nonRosterPresenceMap.a((Object)a2);
        }
        return map;
    }

    private synchronized Map<d, Presence> getOrCreatePresencesInternal(a a2) {
        c c2 = this.getPresencesInternal(a2);
        if (c2 == null) {
            if (this.contains(a2)) {
                c2 = new ConcurrentHashMap<d, Presence>();
                this.presenceMap.put(a2, (Map<d, Presence>)c2);
            } else {
                c c3 = new c(32);
                this.nonRosterPresenceMap.put((Object)a2, (Object)c3);
                c2 = c3;
            }
        }
        return c2;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket rosterPacket = new RosterPacket();
        if (this.rosterStore != null && this.isRosterVersioningSupported()) {
            rosterPacket.setVersion(this.rosterStore.getRosterVersion());
        }
        this.rosterState = RosterState.loading;
        SmackFuture smackFuture = xMPPConnection.sendIqRequestAsync((IQ)rosterPacket);
        smackFuture.onSuccess((SuccessCallback)new RosterResultListener()).onError((ExceptionCallback)new ExceptionCallback<Exception>(){

            public void processException(Exception exception) {
                Roster.this.rosterState = RosterState.uninitialized;
                Level level = exception instanceof SmackException.NotConnectedException ? Level.FINE : Level.SEVERE;
                LOGGER.log(level, "Exception reloading roster", exception);
                for (RosterLoadedListener rosterLoadedListener : Roster.this.rosterLoadedListeners) {
                    rosterLoadedListener.onRosterLoadingFailed(exception);
                }
            }
        });
    }

    public void reloadAndWait() {
        this.reload();
        this.waitUntilLoaded();
    }

    public boolean setRosterStore(RosterStore rosterStore) {
        this.rosterStore = rosterStore;
        try {
            this.reload();
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
            LOGGER.log(Level.FINER, "Could not reload roster", throwable);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitUntilLoaded() {
        long l;
        long l2 = System.currentTimeMillis();
        for (long j = this.connection().getReplyTimeout(); !this.isLoaded() && j > 0L; j -= l - l2) {
            Roster roster = this;
            synchronized (roster) {
                if (!this.isLoaded()) {
                    ((Object)((Object)this)).wait(j);
                }
            }
            l = System.currentTimeMillis();
            l2 = l;
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.rosterState == RosterState.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.add(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.remove(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.add(rosterLoadedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.remove(rosterLoadedListener);
        }
    }

    public boolean addPresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.add(presenceEventListener);
    }

    public boolean removePresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.remove(presenceEventListener);
    }

    public RosterGroup createGroup(String string) {
        XMPPConnection xMPPConnection = this.connection();
        if (this.groups.containsKey(string)) {
            return this.groups.get(string);
        }
        RosterGroup rosterGroup = new RosterGroup(string, xMPPConnection);
        this.groups.put(string, rosterGroup);
        return rosterGroup;
    }

    @Deprecated
    public void createEntry(a a2, String string, String[] stringArray) {
        this.createItemAndRequestSubscription(a2, string, stringArray);
    }

    public void createItem(a a2, String string, String[] stringArray) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        RosterPacket.Item item = new RosterPacket.Item(a2, string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (string2 == null || string2.trim().length() <= 0) continue;
                item.addGroupName(string2);
            }
        }
        rosterPacket.addRosterItem(item);
        xMPPConnection.createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
    }

    public void createItemAndRequestSubscription(a a2, String string, String[] stringArray) {
        this.createItem(a2, string, stringArray);
        this.sendSubscriptionRequest(a2);
    }

    public void preApproveAndCreateEntry(a a2, String string, String[] stringArray) {
        this.preApprove(a2);
        this.createItemAndRequestSubscription(a2, string, stringArray);
    }

    public void preApprove(a a2) {
        XMPPConnection xMPPConnection = this.connection();
        if (!this.isSubscriptionPreApprovalSupported()) {
            throw new SmackException.FeatureNotSupportedException("Pre-approving");
        }
        Presence presence = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribed).to((i)a2)).build();
        xMPPConnection.sendStanza((Stanza)presence);
    }

    public boolean isSubscriptionPreApprovalSupported() {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        return xMPPConnection.hasFeature("sub", "urn:xmpp:features:pre-approval");
    }

    public void sendSubscriptionRequest(a a2) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        Presence presence = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((i)a2)).build();
        xMPPConnection.sendStanza((Stanza)presence);
    }

    public boolean addSubscribeListener(SubscribeListener subscribeListener) {
        Objects.requireNonNull((Object)subscribeListener, (String)"SubscribeListener argument must not be null");
        if (this.subscriptionMode != SubscriptionMode.manual) {
            this.previousSubscriptionMode = this.subscriptionMode;
            this.subscriptionMode = SubscriptionMode.manual;
        }
        return this.subscribeListeners.add(subscribeListener);
    }

    public boolean removeSubscribeListener(SubscribeListener subscribeListener) {
        boolean bl = this.subscribeListeners.remove(subscribeListener);
        if (bl && this.subscribeListeners.isEmpty()) {
            this.setSubscriptionMode(this.previousSubscriptionMode);
        }
        return bl;
    }

    public void removeEntry(RosterEntry rosterEntry) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        if (!this.entries.containsKey(rosterEntry.getJid())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
        item.setItemType(RosterPacket.ItemType.remove);
        rosterPacket.addRosterItem(item);
        xMPPConnection.createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntriesAndAddListener(RosterListener rosterListener, RosterEntries rosterEntries) {
        Objects.requireNonNull((Object)rosterListener, (String)"listener must not be null");
        Objects.requireNonNull((Object)rosterEntries, (String)"rosterEntries must not be null");
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            rosterEntries.rosterEntries(this.entries.values());
            this.addRosterListener(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RosterEntry> getEntries() {
        HashSet<RosterEntry> hashSet;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            hashSet = new HashSet<RosterEntry>(this.entries.size());
            for (RosterEntry rosterEntry : this.entries.values()) {
                hashSet.add(rosterEntry);
            }
        }
        return hashSet;
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Set<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableSet(this.unfiledEntries);
    }

    public RosterEntry getEntry(a a2) {
        if (a2 == null) {
            return null;
        }
        return this.entries.get(a2);
    }

    public boolean contains(a a2) {
        return this.getEntry(a2) != null;
    }

    public RosterGroup getGroup(String string) {
        return this.groups.get(string);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(a a2) {
        Map<d, Presence> map = this.getPresencesInternal(a2);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)a2);
            return presence;
        }
        Presence presence = null;
        Presence presence2 = null;
        for (Presence presence3 : map.values()) {
            Presence.Mode mode;
            if (!presence3.isAvailable()) {
                presence2 = presence3;
                continue;
            }
            if (presence == null || presence3.getPriority() > presence.getPriority()) {
                presence = presence3;
                continue;
            }
            if (presence3.getPriority() != presence.getPriority()) continue;
            Presence.Mode mode2 = presence3.getMode();
            if (mode2 == null) {
                mode2 = Presence.Mode.available;
            }
            if ((mode = presence.getMode()) == null) {
                mode = Presence.Mode.available;
            }
            if (mode2.compareTo((Enum)mode) >= 0) continue;
            presence = presence3;
        }
        if (presence == null) {
            if (presence2 != null) {
                return presence2;
            }
            presence = Roster.synthesizeUnvailablePresence((i)a2);
            return presence;
        }
        return presence;
    }

    public Presence getPresenceResource(h h2) {
        a a2 = h2.n();
        d d2 = h2.d();
        Map<d, Presence> map = this.getPresencesInternal(a2);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)h2);
            return presence;
        }
        Presence presence = map.get(d2);
        if (presence == null) {
            presence = Roster.synthesizeUnvailablePresence((i)h2);
            return presence;
        }
        return presence;
    }

    public List<Presence> getAllPresences(a a2) {
        ArrayList<Presence> arrayList;
        Map<d, Presence> map = this.getPresencesInternal(a2);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)a2);
            arrayList = new ArrayList<Presence>(Arrays.asList(presence));
        } else {
            arrayList = new ArrayList(map.values().size());
            for (Presence presence : map.values()) {
                arrayList.add(presence);
            }
        }
        return arrayList;
    }

    public List<Presence> getAvailablePresences(a a2) {
        List<Presence> list = this.getAllPresences(a2);
        ArrayList<Presence> arrayList = new ArrayList<Presence>(list.size());
        for (Presence presence : list) {
            if (!presence.isAvailable()) continue;
            arrayList.add(presence);
        }
        return arrayList;
    }

    public List<Presence> getPresences(a a2) {
        List<Presence> list;
        Map<d, Presence> map = this.getPresencesInternal(a2);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)a2);
            list = Arrays.asList(presence);
        } else {
            ArrayList<Presence> arrayList = new ArrayList<Presence>();
            Presence presence = null;
            for (Presence presence2 : map.values()) {
                if (presence2.isAvailable()) {
                    arrayList.add(presence2);
                    continue;
                }
                presence = presence2;
            }
            if (!arrayList.isEmpty()) {
                list = arrayList;
            } else if (presence != null) {
                list = Arrays.asList(presence);
            } else {
                Presence presence3 = Roster.synthesizeUnvailablePresence((i)a2);
                list = Arrays.asList(presence3);
            }
        }
        return list;
    }

    public boolean isSubscribedToMyPresence(i i2) {
        if (i2 == null) {
            return false;
        }
        a a2 = i2.n();
        if (this.connection().getXMPPServiceDomain().a((CharSequence)a2)) {
            return true;
        }
        RosterEntry rosterEntry = this.getEntry(a2);
        if (rosterEntry == null) {
            return false;
        }
        return rosterEntry.canSeeMyPresence();
    }

    public boolean iAmSubscribedTo(i i2) {
        if (i2 == null) {
            return false;
        }
        a a2 = i2.n();
        RosterEntry rosterEntry = this.getEntry(a2);
        if (rosterEntry == null) {
            return false;
        }
        return rosterEntry.canSeeHisPresence();
    }

    public static void setRosterLoadedAtLoginDefault(boolean bl) {
        rosterLoadedAtLoginDefault = bl;
    }

    public void setRosterLoadedAtLogin(boolean bl) {
        this.rosterLoadedAtLogin = bl;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    RosterStore getRosterStore() {
        return this.rosterStore;
    }

    private void setOfflinePresences() {
        block3: for (i i2 : this.presenceMap.keySet()) {
            Map<d, Presence> map = this.presenceMap.get(i2);
            if (map == null) continue;
            for (d d2 : map.keySet()) {
                PresenceBuilder presenceBuilder = StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable);
                e e2 = i2.o();
                if (e2 == null) {
                    LOGGER.warning("Can not transform user JID to bare JID: '" + i2 + "'");
                    continue;
                }
                presenceBuilder.from((i)org.e.a.a.d.a((a)e2, (d)d2));
                try {
                    this.presencePacketListener.processStanza((Stanza)presenceBuilder.build());
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new IllegalStateException("presencePacketListener should never throw a NotConnectedException when processStanza is called with a presence of type unavailable", notConnectedException);
                }
                catch (InterruptedException interruptedException) {
                    break block3;
                }
            }
        }
    }

    private void setOfflinePresencesAndResetLoaded() {
        this.setOfflinePresences();
        this.rosterState = RosterState.uninitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterChangedEvent(Collection<i> collection, Collection<i> collection2, Collection<i> collection3) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener rosterListener : this.rosterListeners) {
                if (!collection.isEmpty()) {
                    rosterListener.entriesAdded(collection);
                }
                if (!collection2.isEmpty()) {
                    rosterListener.entriesUpdated(collection2);
                }
                if (collection3.isEmpty()) continue;
                rosterListener.entriesDeleted(collection3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterPresenceEvent(Presence presence) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener rosterListener : this.rosterListeners) {
                rosterListener.presenceChanged(presence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdateEntry(Collection<i> collection, Collection<i> collection2, Collection<i> collection3, RosterPacket.Item item, RosterEntry rosterEntry) {
        Object object2;
        RosterEntry rosterEntry2;
        ArrayList<String> arrayList = this.rosterListenersAndEntriesLock;
        synchronized (arrayList) {
            rosterEntry2 = this.entries.put(item.getJid(), rosterEntry);
        }
        if (rosterEntry2 == null) {
            arrayList = item.getJid();
            collection.add((i)arrayList);
            Roster.move((a)arrayList, this.nonRosterPresenceMap, this.presenceMap);
        } else {
            arrayList = RosterEntry.toRosterItem(rosterEntry2);
            if (!rosterEntry2.equalsDeep((Object)rosterEntry) || !item.getGroupNames().equals(((RosterPacket.Item)((Object)arrayList)).getGroupNames())) {
                collection2.add((i)item.getJid());
                rosterEntry2.updateItem(item);
            } else {
                collection3.add((i)item.getJid());
            }
        }
        if (item.getGroupNames().isEmpty()) {
            this.unfiledEntries.add(rosterEntry);
        } else {
            this.unfiledEntries.remove((Object)rosterEntry);
        }
        arrayList = new ArrayList<String>();
        for (String iterator2 : item.getGroupNames()) {
            arrayList.add(iterator2);
            object2 = this.getGroup(iterator2);
            if (object2 == null) {
                object2 = this.createGroup(iterator2);
                this.groups.put(iterator2, (RosterGroup)((Object)object2));
            }
            object2.addEntryLocal(rosterEntry);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : this.getGroups()) {
            arrayList2.add(object2.getName());
        }
        arrayList2.removeAll(arrayList);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            RosterGroup rosterGroup = this.getGroup((String)object2);
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(object2);
        }
    }

    private void deleteEntry(Collection<i> collection, RosterEntry rosterEntry) {
        a a2 = rosterEntry.getJid();
        this.entries.remove(a2);
        this.unfiledEntries.remove((Object)rosterEntry);
        Roster.move(a2, this.presenceMap, this.nonRosterPresenceMap);
        collection.add((i)a2);
        for (Map.Entry<String, RosterGroup> entry : this.groups.entrySet()) {
            RosterGroup rosterGroup = entry.getValue();
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(entry.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup rosterGroup : this.getGroups()) {
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(rosterGroup.getName());
        }
    }

    private static void move(a a2, Map<a, Map<d, Presence>> map, Map<a, Map<d, Presence>> map2) {
        Map<d, Presence> map3 = map.remove(a2);
        if (map3 != null && !map3.isEmpty()) {
            map2.put(a2, map3);
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        switch (item.getItemType()) {
            case none: 
            case from: 
            case to: 
            case both: {
                return true;
            }
        }
        return false;
    }

    private static Presence synthesizeUnvailablePresence(i i2) {
        return ((PresenceBuilder)StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable).from(i2)).build();
    }

    public boolean isRosterVersioningSupported() {
        return this.connection().hasFeature("ver", "urn:xmpp:features:rosterver");
    }

    public static void setDefaultNonRosterPresenceMapMaxSize(int n) {
        defaultNonRosterPresenceMapMaxSize = n;
    }

    public void setNonRosterPresenceMapMaxSize(int n) {
        this.nonRosterPresenceMap.a(n);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                Roster.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Roster>();
        PRESENCE_PACKET_FILTER = StanzaTypeFilter.PRESENCE;
        OUTGOING_USER_UNAVAILABLE_PRESENCE = new AndFilter(new StanzaFilter[]{PresenceTypeFilter.UNAVAILABLE, ToMatchesFilter.MATCH_NO_TO_SET});
        rosterLoadedAtLoginDefault = true;
        defaultSubscriptionMode = SubscriptionMode.reject_all;
        defaultNonRosterPresenceMapMaxSize = 1024;
    }

    private final class RosterPushListener
    extends AbstractIqRequestHandler {
        private RosterPushListener() {
            super("query", "jabber:iq:roster", IQ.Type.set, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iQ) {
            List<RosterPacket.Item> list;
            XMPPConnection xMPPConnection = Roster.this.connection();
            RosterPacket rosterPacket = (RosterPacket)iQ;
            f f2 = xMPPConnection.getUser();
            if (f2 == null) {
                LOGGER.warning("Ignoring roster push " + iQ + " while " + xMPPConnection + " has no bound resource. This may be a server bug.");
                return null;
            }
            e e2 = f2.b();
            i i2 = rosterPacket.getFrom();
            if (i2 != null) {
                if (i2.a((CharSequence)f2)) {
                    LOGGER.warning("Received roster push from full JID. This behavior is since RFC 6121 not longer standard compliant. Please ask your server vendor to fix this and comply to RFC 6121 \u00a7 2.1.6. IQ roster push stanza: " + iQ);
                } else if (!i2.a((CharSequence)e2)) {
                    LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid='" + e2 + "' from='" + i2 + "'");
                    return IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.service_unavailable);
                }
            }
            if ((list = rosterPacket.getRosterItems()).size() != 1) {
                LOGGER.warning("Ignoring roster push with not exactly one entry. size=" + list.size());
                return IQ.createErrorResponse((IQ)iQ, (StanzaError.Condition)StanzaError.Condition.bad_request);
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            RosterPacket.Item item = (RosterPacket.Item)list.iterator().next();
            RosterEntry rosterEntry = new RosterEntry(item, Roster.this, xMPPConnection);
            String string = rosterPacket.getVersion();
            if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry(arrayList3, rosterEntry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry((i)rosterEntry.getJid(), string);
                }
            } else if (Roster.hasValidSubscriptionType(item)) {
                Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, rosterEntry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry(item, string);
                }
            }
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
            return IQ.createResultIQ((IQ)rosterPacket);
        }
    }

    private class RosterResultListener
    implements SuccessCallback<IQ> {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(IQ iQ) {
            Object object42;
            Iterator<RosterPacket.Item> iterator;
            Object object3;
            XMPPConnection xMPPConnection = Roster.this.connection();
            LOGGER.log(Level.FINE, "RosterResultListener received {0}", iQ);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (iQ instanceof RosterPacket) {
                RosterEntry rosterEntry2;
                object3 = (RosterPacket)iQ;
                iterator = new ArrayList();
                for (RosterPacket.Item object22 : ((RosterPacket)((Object)object3)).getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(object22)) continue;
                    ((ArrayList)((Object)iterator)).add(object22);
                }
                object42 = ((ArrayList)((Object)iterator)).iterator();
                while (object42.hasNext()) {
                    RosterPacket.Item item = (RosterPacket.Item)object42.next();
                    rosterEntry2 = new RosterEntry(item, Roster.this, xMPPConnection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, rosterEntry2);
                }
                object42 = new HashSet<a>();
                for (RosterEntry rosterEntry2 : Roster.this.entries.values()) {
                    object42.add(rosterEntry2.getJid());
                }
                object42.removeAll(arrayList);
                object42.removeAll(arrayList2);
                object42.removeAll(arrayList4);
                Iterator iterator2 = object42.iterator();
                while (iterator2.hasNext()) {
                    rosterEntry2 = (i)iterator2.next();
                    Roster.this.deleteEntry(arrayList3, (RosterEntry)((Object)Roster.this.entries.get((Object)rosterEntry2)));
                }
                if (Roster.this.rosterStore != null) {
                    String string = ((RosterPacket)((Object)object3)).getVersion();
                    Roster.this.rosterStore.resetEntries((Collection<RosterPacket.Item>)((Object)iterator), string);
                }
                Roster.this.removeEmptyGroups();
            } else {
                object3 = Roster.this.rosterStore.getEntries();
                if (object3 == null) {
                    Roster.this.rosterStore.resetStore();
                    try {
                        Roster.this.reload();
                    }
                    catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
                        LOGGER.log(Level.FINE, "Exception while trying to load the roster after the roster store was corrupted", throwable);
                    }
                    return;
                }
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object42 = (RosterPacket.Item)iterator.next();
                    RosterEntry rosterEntry = new RosterEntry((RosterPacket.Item)object42, Roster.this, xMPPConnection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, object42, rosterEntry);
                }
            }
            Roster.this.rosterState = RosterState.loaded;
            object3 = Roster.this;
            synchronized (object3) {
                ((Object)((Object)Roster.this)).notifyAll();
            }
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
            try {
                object3 = Roster.this.rosterLoadedListeners;
                synchronized (object3) {
                    for (Object object42 : Roster.this.rosterLoadedListeners) {
                        object42.onRosterLoaded(Roster.this);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "RosterLoadedListener threw exception", exception);
            }
        }
    }

    private class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        public void processStanza(Stanza stanza) {
            a a2;
            Presence presence;
            if (Roster.this.rosterState == RosterState.loading) {
                try {
                    Roster.this.waitUntilLoaded();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.INFO, "Presence listener was interrupted", interruptedException);
                }
            }
            final i i2 = stanza.getFrom();
            if (!Roster.this.isLoaded() && Roster.this.rosterLoadedAtLogin && (presence = Roster.this.connection()) != null && i2 != null && !i2.a((CharSequence)presence.getUser())) {
                LOGGER.warning("Roster not loaded while processing " + stanza);
            }
            presence = (Presence)stanza;
            if (i2 != null) {
                a2 = i2.n();
            } else {
                XMPPConnection xMPPConnection = Roster.this.connection();
                if (xMPPConnection == null) {
                    LOGGER.finest("Connection was null while trying to handle exotic presence stanza: " + presence);
                    return;
                }
                f f2 = xMPPConnection.getUser();
                if (f2 == null) {
                    LOGGER.info("Connection had no local address in Roster's presence listener. Possibly we received a presence without from before being authenticated. Presence: " + presence);
                    return;
                }
                LOGGER.info("Exotic presence stanza without from received: " + presence);
                a2 = f2.n();
            }
            Roster.this.asyncButOrdered.performAsyncButOrdered((Object)a2, new Runnable(){

                @Override
                public void run() {
                    d d2 = d.a;
                    a a22 = null;
                    h h2 = null;
                    if (i2 != null) {
                        d2 = i2.x();
                        if (d2 == null) {
                            d2 = d.a;
                            a22 = i2.n();
                        } else {
                            h2 = i2.t();
                            assert (h2 != null);
                        }
                    }
                    switch (presence.getType()) {
                        case available: {
                            Map map = Roster.this.getOrCreatePresencesInternal(a2);
                            map.remove(d.a);
                            map.put(d2, presence);
                            if (Roster.this.contains(a2)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceAvailable(h2, presence);
                            }
                            break;
                        }
                        case unavailable: {
                            Map map = Roster.this.getOrCreatePresencesInternal(a2);
                            if (i2.k()) {
                                map.put(d.a, presence);
                            } else {
                                map.put(d2, presence);
                            }
                            if (Roster.this.contains(a2)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            if (h2 != null) {
                                for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                    presenceEventListener.presenceUnavailable(h2, presence);
                                }
                                break;
                            }
                            LOGGER.fine("Unavailable presence from bare JID: " + presence);
                            break;
                        }
                        case error: {
                            if (i2 == null || !i2.g()) break;
                            Map map = Roster.this.getOrCreatePresencesInternal(a2);
                            map.clear();
                            map.put(d.a, presence);
                            if (Roster.this.contains(a2)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceError(i2, presence);
                            }
                            break;
                        }
                        case subscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceSubscribed(a22, presence);
                            }
                            break;
                        }
                        case unsubscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceUnsubscribed(a22, presence);
                            }
                            break;
                        }
                    }
                }
            });
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }

    private static enum RosterState {
        uninitialized,
        loading,
        loaded;

    }
}

