/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.TextUndoManager;
import androidx.compose.foundation.text.input.internal.undo.TextDeleteType;
import androidx.compose.foundation.text.input.internal.undo.TextEditType;
import androidx.compose.foundation.text.input.internal.undo.TextUndoOperation;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a.\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\"\u0018\u0010\r\u001a\u00020\f*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"merge", "Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "next", "recordChanges", "", "Landroidx/compose/foundation/text/input/TextUndoManager;", "pre", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "post", "changes", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "allowMerge", "", "isNewLineInsert", "(Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;)Z", "TEXT_UNDO_CAPACITY", "", "foundation"})
public final class TextUndoManagerKt {
    private static final int TEXT_UNDO_CAPACITY = 100;

    public static final TextUndoOperation merge(TextUndoOperation textUndoOperation, TextUndoOperation textUndoOperation2) {
        Intrinsics.checkNotNullParameter((Object)textUndoOperation, (String)"");
        Intrinsics.checkNotNullParameter((Object)textUndoOperation2, (String)"");
        if (!textUndoOperation.getCanMerge() || !textUndoOperation2.getCanMerge()) {
            return null;
        }
        if (textUndoOperation2.getTimeInMillis() < textUndoOperation.getTimeInMillis() || textUndoOperation2.getTimeInMillis() - textUndoOperation.getTimeInMillis() >= (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) {
            return null;
        }
        if (TextUndoManagerKt.isNewLineInsert(textUndoOperation) || TextUndoManagerKt.isNewLineInsert(textUndoOperation2)) {
            return null;
        }
        if (textUndoOperation.getTextEditType() != textUndoOperation2.getTextEditType()) {
            return null;
        }
        if (textUndoOperation.getTextEditType() == TextEditType.Insert && textUndoOperation.getIndex() + textUndoOperation.getPostText().length() == textUndoOperation2.getIndex()) {
            return new TextUndoOperation(textUndoOperation.getIndex(), "", textUndoOperation.getPostText() + textUndoOperation2.getPostText(), textUndoOperation.getPreSelection-d9O1mEE(), textUndoOperation2.getPostSelection-d9O1mEE(), textUndoOperation.getTimeInMillis(), false, 64, null);
        }
        if (textUndoOperation.getTextEditType() == TextEditType.Delete && textUndoOperation.getDeletionType() == textUndoOperation2.getDeletionType() && (textUndoOperation.getDeletionType() == TextDeleteType.Start || textUndoOperation.getDeletionType() == TextDeleteType.End)) {
            if (textUndoOperation.getIndex() == textUndoOperation2.getIndex() + textUndoOperation2.getPreText().length()) {
                return new TextUndoOperation(textUndoOperation2.getIndex(), textUndoOperation2.getPreText() + textUndoOperation.getPreText(), "", textUndoOperation.getPreSelection-d9O1mEE(), textUndoOperation2.getPostSelection-d9O1mEE(), textUndoOperation.getTimeInMillis(), false, 64, null);
            }
            if (textUndoOperation.getIndex() == textUndoOperation2.getIndex()) {
                return new TextUndoOperation(textUndoOperation.getIndex(), textUndoOperation.getPreText() + textUndoOperation2.getPreText(), "", textUndoOperation.getPreSelection-d9O1mEE(), textUndoOperation2.getPostSelection-d9O1mEE(), textUndoOperation.getTimeInMillis(), false, 64, null);
            }
        }
        return null;
    }

    public static final void recordChanges(TextUndoManager textUndoManager, TextFieldCharSequence textFieldCharSequence, TextFieldCharSequence textFieldCharSequence2, TextFieldBuffer.ChangeList changeList, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)textUndoManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldCharSequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldCharSequence2, (String)"");
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"");
        if (changeList.getChangeCount() > 1) {
            textUndoManager.record(new TextUndoOperation(0, textFieldCharSequence.toString(), textFieldCharSequence2.toString(), textFieldCharSequence.getSelection-d9O1mEE(), textFieldCharSequence2.getSelection-d9O1mEE(), 0L, false, 32, null));
        } else if (changeList.getChangeCount() == 1) {
            long l2 = changeList.getOriginalRange--jx7JFs(0);
            long l3 = changeList.getRange--jx7JFs(0);
            if (!TextRange.getCollapsed-impl((long)l2) || !TextRange.getCollapsed-impl((long)l3)) {
                textUndoManager.record(new TextUndoOperation(TextRange.getMin-impl((long)l2), TextRangeKt.substring-FDrldGo((CharSequence)textFieldCharSequence, (long)l2), TextRangeKt.substring-FDrldGo((CharSequence)textFieldCharSequence2, (long)l3), textFieldCharSequence.getSelection-d9O1mEE(), textFieldCharSequence2.getSelection-d9O1mEE(), 0L, bl, 32, null));
            }
        }
    }

    public static /* synthetic */ void recordChanges$default(TextUndoManager textUndoManager, TextFieldCharSequence textFieldCharSequence, TextFieldCharSequence textFieldCharSequence2, TextFieldBuffer.ChangeList changeList, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        TextUndoManagerKt.recordChanges(textUndoManager, textFieldCharSequence, textFieldCharSequence2, changeList, bl);
    }

    private static final boolean isNewLineInsert(TextUndoOperation textUndoOperation) {
        return Intrinsics.areEqual((Object)textUndoOperation.getPostText(), (Object)"\n") || Intrinsics.areEqual((Object)textUndoOperation.getPostText(), (Object)"\r\n");
    }
}

