/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.b.I;
import androidx.b.q;
import androidx.b.t;
import androidx.b.u;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0.H\u0016J\u0012\u0010/\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0000H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\r032\u0006\u00104\u001a\u00020\rH\u0016J2\u00105\u001a\u00020,*\b\u0012\u0004\u0012\u00020\r062\u0006\u00104\u001a\u00020\r2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u000bH\u0002J\u0018\u0010?\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u000bH\u0002J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0017R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"\u00a8\u0006D"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "Landroidx/collection/LongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "<init>", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "getSelectableIdToInfoListIndex", "()Landroidx/collection/LongIntMap;", "getInfoList", "()Ljava/util/List;", "getStartSlot", "()I", "getEndSlot", "()Z", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "size", "getSize", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "startInfo", "getStartInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "currentInfo", "getCurrentInfo", "firstInfo", "getFirstInfo", "lastInfo", "getLastInfo", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "shouldRecomputeSelection", "other", "shouldAnyInfoRecomputeSelection", "createSubSelections", "Landroidx/collection/LongObjectMap;", "selection", "createAndPutSubSelection", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "toString", "", "startOrEndSlotToIndex", "slot", "isStartSlot", "slotToIndex", "isMinimumSlot", "getInfoListIndexBySelectableId", "id", "", "foundation"})
final class MultiSelectionLayout
implements SelectionLayout {
    private final q selectableIdToInfoListIndex;
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    private final Selection previousSelection;

    public MultiSelectionLayout(q q2, List<SelectableInfo> list, int n2, int n3, boolean bl, Selection selection) {
        Intrinsics.checkNotNullParameter((Object)q2, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.selectableIdToInfoListIndex = q2;
        this.infoList = list;
        this.startSlot = n2;
        this.endSlot = n3;
        this.isStartHandle = bl;
        this.previousSelection = selection;
        boolean bl2 = this.infoList.size() > 1;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            InlineClassHelperKt.throwIllegalStateException("MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + ".");
        }
    }

    public final q getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public int getSize() {
        return this.infoList.size();
    }

    @Override
    public CrossStatus getCrossStatus() {
        return this.getStartSlot() < this.getEndSlot() ? CrossStatus.NOT_CROSSED : (this.getStartSlot() > this.getEndSlot() ? CrossStatus.CROSSED : this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus());
    }

    @Override
    public SelectableInfo getStartInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getStartSlot(), true));
    }

    @Override
    public SelectableInfo getEndInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getEndSlot(), false));
    }

    @Override
    public SelectableInfo getCurrentInfo() {
        return this.isStartHandle() ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    public SelectableInfo getFirstInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getEndInfo() : this.getStartInfo();
    }

    @Override
    public SelectableInfo getLastInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    public void forEachMiddleInfo(Function1<? super SelectableInfo, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        int n2 = this.getInfoListIndexBySelectableId(this.getFirstInfo().getSelectableId());
        int n3 = this.getInfoListIndexBySelectableId(this.getLastInfo().getSelectableId());
        if (n2 + 1 >= n3) {
            return;
        }
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            function1.invoke((Object)this.infoList.get(i2));
        }
    }

    @Override
    public boolean shouldRecomputeSelection(SelectionLayout selectionLayout) {
        return this.getPreviousSelection() == null || selectionLayout == null || !(selectionLayout instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)selectionLayout).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)selectionLayout).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)selectionLayout).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)selectionLayout);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout multiSelectionLayout) {
        if (this.getSize() != multiSelectionLayout.getSize()) {
            return true;
        }
        int n2 = ((Collection)this.infoList).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SelectableInfo selectableInfo;
            SelectableInfo selectableInfo2 = this.infoList.get(i2);
            if (!selectableInfo2.shouldRecomputeSelection(selectableInfo = multiSelectionLayout.infoList.get(i2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public t<Selection> createSubSelections(Selection selection) {
        t t2;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            boolean bl = selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset();
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                InlineClassHelperKt.throwIllegalStateException("unexpectedly miss-crossed selection: " + selection);
            }
            t2 = u.a((long)selection.getStart().getSelectableId(), (Object)selection);
        } else {
            I i2;
            I i3 = i2 = u.b();
            boolean bl = false;
            Object object = selection;
            boolean bl4 = false;
            Selection.AnchorInfo anchorInfo = ((Selection)object).getHandlesCrossed() ? ((Selection)object).getEnd() : ((Selection)object).getStart();
            this.createAndPutSubSelection((I<Selection>)i3, selection, this.getFirstInfo(), anchorInfo.getOffset(), this.getFirstInfo().getTextLength());
            this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)arg_0 -> MultiSelectionLayout.createSubSelections$lambda$5$lambda$3(this, i3, selection, arg_0)));
            Selection selection2 = selection;
            boolean bl5 = false;
            object = selection2.getHandlesCrossed() ? selection2.getStart() : selection2.getEnd();
            this.createAndPutSubSelection((I<Selection>)i3, selection, this.getLastInfo(), 0, ((Selection.AnchorInfo)object).getOffset());
            t2 = (t)i2;
        }
        return t2;
    }

    private final void createAndPutSubSelection(I<Selection> i2, Selection selection, SelectableInfo selectableInfo, int n2, int n3) {
        Selection selection2 = selection.getHandlesCrossed() ? selectableInfo.makeSingleLayoutSelection(n3, n2) : selectableInfo.makeSingleLayoutSelection(n2, n3);
        boolean bl = n2 <= n3;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            InlineClassHelperKt.throwIllegalStateException("minOffset should be less than or equal to maxOffset: " + selection2);
        }
        i2.b(selectableInfo.getSelectableId(), (Object)selection2);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CrossStatus crossStatus = this.getCrossStatus();
        float f2 = (float)(this.getEndSlot() + 1) / (float)2;
        float f3 = (float)(this.getStartSlot() + 1) / (float)2;
        boolean bl = this.isStartHandle();
        boolean bl2 = false;
        stringBuilder2.append("[\n\t");
        boolean bl3 = false;
        bl3 = true;
        List<SelectableInfo> list = this.infoList;
        boolean bl4 = false;
        int n2 = ((Collection)list).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SelectableInfo selectableInfo;
            SelectableInfo selectableInfo2 = selectableInfo = list.get(i2);
            int n3 = i2;
            boolean bl5 = false;
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder2.append(",\n\t");
            }
            stringBuilder2.append(n3 + 1 + " -> " + selectableInfo2);
        }
        stringBuilder2.append("\n]");
        Unit unit = Unit.INSTANCE;
        return "MultiSelectionLayout(isStartHandle=" + bl + ", startPosition=" + f3 + ", endPosition=" + f2 + ", crossed=" + crossStatus + ", infos=" + stringBuilder.toString() + ")";
    }

    private final int startOrEndSlotToIndex(int n2, boolean bl) {
        boolean bl2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = bl;
                break;
            }
            case 3: {
                if (!bl) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex(n2, bl2);
    }

    private final int slotToIndex(int n2, boolean bl) {
        int n3 = bl ? 0 : 1;
        return (n2 - n3) / 2;
    }

    private final int getInfoListIndexBySelectableId(long l2) {
        int n2;
        try {
            n2 = this.selectableIdToInfoListIndex.a(l2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("Invalid selectableId: " + l2, noSuchElementException);
        }
        return n2;
    }

    private static final Unit createSubSelections$lambda$5$lambda$3(MultiSelectionLayout multiSelectionLayout, I i2, Selection selection, SelectableInfo selectableInfo) {
        Intrinsics.checkNotNullParameter((Object)selectableInfo, (String)"");
        multiSelectionLayout.createAndPutSubSelection((I<Selection>)i2, selection, selectableInfo, 0, selectableInfo.getTextLength());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

