/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Menu;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class Entry {
    private static final AtomicInteger MENU_ID_COUNTER = new AtomicInteger(0);
    private final int id = MENU_ID_COUNTER.getAndIncrement();
    private volatile Menu parent;
    protected volatile EntryPeer peer;
    protected volatile ImageResizeUtil imageResizeUtil;

    public void bind(EntryPeer entryPeer, Menu menu, ImageResizeUtil imageResizeUtil) {
        this.parent = menu;
        this.peer = entryPeer;
        this.imageResizeUtil = imageResizeUtil;
    }

    public final boolean hasPeer() {
        return this.peer != null;
    }

    public final Menu getParent() {
        return this.parent;
    }

    public final ImageResizeUtil getImageResizeUtil() {
        return this.imageResizeUtil;
    }

    public void remove() {
        if (this.peer != null) {
            this.peer.remove();
            this.parent = null;
            this.peer = null;
        }
    }

    public final int hashCode() {
        return this.id;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Entry entry = (Entry)object;
        return this.id == entry.id;
    }
}

