/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.util.CacheUtil;
import dorkbox.util.IO;
import dorkbox.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImageResizeUtil {
    private static final Pattern JAR_URL_REGEX = Pattern.compile(".*.jar!.*");
    private final CacheUtil cache;

    public ImageResizeUtil(CacheUtil cacheUtil) {
        this.cache = cacheUtil;
    }

    public File getTransparentImage() {
        return this.getTransparentImage(4);
    }

    public File getTransparentImage(int n) {
        try {
            File file = this.cache.create(n + "_empty.png");
            return ImageUtil.createImage((int)n, (File)file, null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to generate transparent image! Something is severely wrong!");
        }
    }

    public synchronized File getErrorImage(int n) {
        if (n <= 0) {
            n = 32;
        }
        try {
            InputStream inputStream = ImageResizeUtil.class.getResource("error_32.png").openStream();
            inputStream = ImageResizeUtil.makeByteArrayInputStream(inputStream);
            inputStream.mark(0);
            String string = n + "_" + CacheUtil.Companion.createNameAsHash(inputStream);
            ((ByteArrayInputStream)inputStream).reset();
            File file = this.cache.check(string);
            if (file != null) {
                return file;
            }
            File file2 = this.resizeFileNoCheck(n, inputStream);
            return this.cache.save(string, file2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Serious problems! Unable to extract error image, this should NEVER happen!", exception);
        }
    }

    private File resizeAndCache(int n, File file) {
        return this.resizeAndCache(n, file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File resizeAndCache(int n, String string) {
        if (string == null) {
            return null;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Resizing image to " + n + " : " + string);
        }
        InputStream inputStream = null;
        try {
            Serializable serializable;
            if (JAR_URL_REGEX.matcher(string).matches()) {
                serializable = new URL(string);
                inputStream = serializable.openStream();
            } else {
                inputStream = new FileInputStream(string);
            }
            serializable = this.resizeAndCache(n, inputStream);
            return serializable;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception);
            File file = this.getErrorImage(n);
            return file;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File resizeAndCache(int n, InputStream inputStream) {
        File file;
        String string;
        if (inputStream == null) {
            return null;
        }
        boolean bl = true;
        try {
            inputStream = ImageResizeUtil.makeByteArrayInputStream(inputStream);
            inputStream.mark(0);
            string = n + "_" + CacheUtil.Companion.createNameAsHash(inputStream);
            ((ByteArrayInputStream)inputStream).reset();
            file = this.cache.check(string);
            if (file != null && file.canRead()) {
                File file2 = file;
                return file2;
            }
            inputStream.mark(0);
            Dimension dimension = ImageUtil.getImageSize((InputStream)inputStream);
            if (n == (int)dimension.getHeight() && n == (int)dimension.getWidth()) {
                bl = false;
            }
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error getting image size. Using error icon instead", (Throwable)exception);
            File file3 = this.getErrorImage(n);
            return file3;
        }
        finally {
            ((ByteArrayInputStream)inputStream).reset();
        }
        if (bl) {
            try {
                file = this.resizeFileNoCheck(n, inputStream);
                try {
                    return this.cache.save(string, file);
                }
                catch (Exception exception) {
                    SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)exception);
                    return this.getErrorImage(n);
                }
            }
            catch (Exception exception) {
                SystemTray.logger.error("Error resizing image. Using error icon instead", (Throwable)exception);
                return this.getErrorImage(n);
            }
        }
        try {
            return this.cache.save(string, inputStream);
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)exception);
            return this.getErrorImage(n);
        }
    }

    private static InputStream makeByteArrayInputStream(InputStream inputStream) {
        if (!(inputStream instanceof ByteArrayInputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream((InputStream)inputStream);
            inputStream.close();
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return inputStream;
    }

    private File resizeFileNoCheck(int n, InputStream inputStream) {
        File file = this.cache.create("temp_resize.png");
        file.delete();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        ImageUtil.waitForImageLoad((Image)bufferedImage);
        BufferedImage bufferedImage2 = ImageUtil.getBufferedImage((Image)bufferedImage);
        int n2 = bufferedImage2.getWidth();
        int n3 = bufferedImage2.getHeight();
        bufferedImage2 = n2 > n3 ? ImageUtil.resizeImage((BufferedImage)bufferedImage2, (int)n, (int)-1) : ImageUtil.resizeImage((BufferedImage)bufferedImage2, (int)-1, (int)n);
        bufferedImage2 = ImageUtil.getSquareBufferedImage((Image)bufferedImage2);
        ImageIO.write((RenderedImage)bufferedImage2, "png", file);
        return file;
    }

    public File shouldResizeOrCache(boolean bl, File file) {
        if (file == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int n = ImageResizeUtil.getSize(bl);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + n + " : " + file);
            }
            return this.resizeAndCache(n, file);
        }
        return file;
    }

    public File shouldResizeOrCache(boolean bl, String string) {
        if (string == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int n = ImageResizeUtil.getSize(bl);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + n + " : " + string);
            }
            return this.resizeAndCache(n, string);
        }
        return new File(string);
    }

    public File shouldResizeOrCache(boolean bl, URL uRL) {
        if (uRL == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + n + " : " + uRL);
                }
                InputStream inputStream = uRL.openStream();
                File file = this.resizeAndCache(n, inputStream);
                inputStream.close();
                return file;
            }
            return this.cache.save(uRL);
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception);
            return this.getErrorImage(n);
        }
    }

    public File shouldResizeOrCache(boolean bl, InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        if (SystemTray.AUTO_SIZE) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image-stream to " + n);
            }
            return this.resizeAndCache(n, inputStream);
        }
        try {
            return this.cache.save(inputStream);
        }
        catch (IOException iOException) {
            SystemTray.logger.error("Error checking cache for information. Using error icon instead", (Throwable)iOException);
            return this.getErrorImage(n);
        }
    }

    public File shouldResizeOrCache(boolean bl, Image image) {
        if (image == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            File file;
            ImageUtil.waitForImageLoad((Image)image);
            BufferedImage bufferedImage = ImageUtil.getBufferedImage((Image)image);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + n);
                }
                file = this.resizeAndCache(n, byteArrayInputStream);
            } else {
                file = this.cache.save((InputStream)byteArrayInputStream);
            }
            ((InputStream)byteArrayInputStream).close();
            return file;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception);
            return this.getErrorImage(n);
        }
    }

    public File shouldResizeOrCache(boolean bl, ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream((ImageInputStream)imageInputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image-stream to " + n);
                }
                return this.resizeAndCache(n, byteArrayInputStream);
            }
            return this.cache.save((InputStream)byteArrayInputStream);
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception);
            return this.getErrorImage(n);
        }
    }

    private static int getSize(boolean bl) {
        int n = bl ? SizeAndScaling.TRAY_SIZE : SizeAndScaling.TRAY_MENU_SIZE;
        return n;
    }
}

