/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import jogamp.openal.ALCImpl;
import jogamp.openal.ALExtImpl;
import jogamp.openal.ALImpl;
import jogamp.openal.Debug;

public class ALFactory {
    public static final boolean DEBUG = Debug.debug("Factory");
    public static final boolean PREFER_SYSTEM_OPENAL;
    private static boolean initialized;
    private static AL al;
    private static ALC alc;
    private static ALExt alext;

    private ALFactory() {
    }

    private static synchronized void initialize() {
        try {
            if (!initialized) {
                if (null == ALImpl.getALProcAddressTable()) {
                    throw new ALException("AL not initialized (ProcAddressTable null)");
                }
                initialized = true;
                if (DEBUG) {
                    System.err.println("AL initialized");
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new ALException(unsatisfiedLinkError);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new ALException(exceptionInInitializerError);
        }
    }

    public static boolean getPreferSystemOpenAL() {
        ALFactory.initialize();
        return PREFER_SYSTEM_OPENAL;
    }

    public static AL getAL() {
        ALFactory.initialize();
        if (al == null) {
            al = new ALImpl();
        }
        return al;
    }

    public static ALC getALC() {
        ALFactory.initialize();
        if (alc == null) {
            alc = new ALCImpl();
        }
        return alc;
    }

    public static ALExt getALExt() {
        ALFactory.initialize();
        if (alext == null) {
            alext = new ALExtImpl();
        }
        return alext;
    }

    static {
        Platform.initSingleton();
        String string = PropertyAccess.getProperty((String)"joal.openal.lib", (boolean)true);
        boolean bl = false;
        if (null != string) {
            if (string.equals("system")) {
                bl = true;
            } else if (string.equals("soft")) {
                bl = false;
            }
        }
        PREFER_SYSTEM_OPENAL = bl;
        initialized = false;
    }
}

