/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ALut {
    private static ALC alc;
    private static ALCdevice device;
    private static ALCcontext context;
    private static Thread initializingThread;

    private ALut() {
    }

    public static synchronized void alutInit() {
        String string;
        ALCdevice aLCdevice;
        if (context != null) {
            throw new ALException("Already initialized on thread " + initializingThread.getName());
        }
        if (alc == null) {
            alc = ALFactory.getALC();
        }
        if ((aLCdevice = alc.alcOpenDevice(string = null)) == null) {
            throw new ALException("Error opening default OpenAL device");
        }
        ALCcontext aLCcontext = alc.alcCreateContext(aLCdevice, null);
        if (aLCcontext == null) {
            alc.alcCloseDevice(aLCdevice);
            throw new ALException("Error creating OpenAL context");
        }
        alc.alcMakeContextCurrent(aLCcontext);
        if (alc.alcGetError(aLCdevice) != 0) {
            alc.alcDestroyContext(aLCcontext);
            alc.alcCloseDevice(aLCdevice);
            throw new ALException("Error making OpenAL context current");
        }
        device = aLCdevice;
        context = aLCcontext;
        initializingThread = Thread.currentThread();
    }

    public static synchronized void alutExit() {
        if (context == null) {
            throw new ALException("Not initialized");
        }
        alc.alcMakeContextCurrent(null);
        alc.alcDestroyContext(context);
        alc.alcCloseDevice(device);
        context = null;
        device = null;
        initializingThread = null;
    }

    public static void alutLoadWAVFile(String string, int[] nArray, ByteBuffer[] byteBufferArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        try {
            WAVData wAVData = WAVLoader.loadFromFile(string);
            nArray[0] = wAVData.format;
            byteBufferArray[0] = wAVData.data;
            nArray2[0] = wAVData.size;
            nArray3[0] = wAVData.freq;
            nArray4[0] = wAVData.loop ? 1 : 0;
        }
        catch (Exception exception) {
            throw new ALException(exception);
        }
    }

    public static void alutLoadWAVFile(InputStream inputStream, int[] nArray, ByteBuffer[] byteBufferArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            WAVData wAVData = WAVLoader.loadFromStream(inputStream);
            nArray[0] = wAVData.format;
            byteBufferArray[0] = wAVData.data;
            nArray2[0] = wAVData.size;
            nArray3[0] = wAVData.freq;
            nArray4[0] = wAVData.loop ? 1 : 0;
        }
        catch (Exception exception) {
            throw new ALException(exception);
        }
    }
}

