/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import jogamp.common.os.PlatformPropsImpl;

public class SecurityUtil {
    private static final SecurityManager securityManager;
    private static final Permission allPermissions;
    private static final boolean DEBUG = false;
    private static final RuntimePermission allLinkPermission;

    public static final SecurityManager getSecurityManager() {
        if (PlatformPropsImpl.JAVA_17) {
            return null;
        }
        return System.getSecurityManager();
    }

    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (PlatformPropsImpl.JAVA_17) {
            return privilegedAction.run();
        }
        return AccessController.doPrivileged(privilegedAction);
    }

    public static final boolean hasAllPermissions() {
        return SecurityUtil.hasPermission(allPermissions);
    }

    public static final boolean hasPermission(Permission permission) {
        try {
            SecurityUtil.checkPermission(permission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static final void checkAllPermissions() {
        SecurityUtil.checkPermission(allPermissions);
    }

    public static final void checkPermission(Permission permission) {
        if (null != securityManager) {
            securityManager.checkPermission(permission);
        }
    }

    public static final boolean hasLinkPermission(String string) {
        try {
            SecurityUtil.checkLinkPermission(string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static final void checkLinkPermission(String string) {
        if (null != securityManager) {
            securityManager.checkLink(string);
        }
    }

    public static final void checkAllLinkPermission() {
        if (null != securityManager) {
            securityManager.checkPermission(allLinkPermission);
        }
    }

    public static final Certificate[] getCerts(Class<?> clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = null != protectionDomain ? protectionDomain.getCodeSource() : null;
        Certificate[] certificateArray = null != codeSource ? codeSource.getCertificates() : null;
        return null != certificateArray && certificateArray.length > 0 ? certificateArray : null;
    }

    public static final boolean equals(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        if (certificateArray == certificateArray2) {
            return true;
        }
        if (certificateArray == null || certificateArray2 == null) {
            return false;
        }
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        for (n = 0; n < certificateArray.length && certificateArray[n].equals(certificateArray2[n]); ++n) {
        }
        return n == certificateArray.length;
    }

    static {
        allPermissions = new AllPermission();
        securityManager = SecurityUtil.getSecurityManager();
        allLinkPermission = new RuntimePermission("loadLibrary.*");
    }
}

