/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.File;
import jogamp.common.util.locks.SingletonInstanceFileLock;
import jogamp.common.util.locks.SingletonInstanceServerSocket;

public abstract class SingletonInstance
implements Lock {
    protected static final boolean DEBUG = true;
    private final long poll_ms;
    private boolean locked = false;

    public static SingletonInstance createFileLock(long l, String string) {
        return new SingletonInstanceFileLock(l, string);
    }

    public static SingletonInstance createFileLock(long l, File file) {
        return new SingletonInstanceFileLock(l, file);
    }

    public static SingletonInstance createServerSocket(long l, int n) {
        return new SingletonInstanceServerSocket(l, n);
    }

    protected SingletonInstance(long l) {
        this.poll_ms = Math.max(10L, l);
    }

    public final long getPollPeriod() {
        return this.poll_ms;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName();
    }

    @Override
    public synchronized void lock() {
        try {
            while (!this.tryLock(TIMEOUT)) {
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException);
        }
    }

    @Override
    public synchronized boolean tryLock(long l) {
        long l2;
        if (this.locked) {
            return true;
        }
        long l3 = System.currentTimeMillis();
        int n = 0;
        try {
            do {
                l2 = System.currentTimeMillis();
                this.locked = this.tryLockImpl();
                if (this.locked) {
                    long l4 = System.currentTimeMillis();
                    System.err.println(this.infoPrefix(l4) + " +++ " + this.getName() + " - Locked within " + (l4 - l3) + " ms, " + (n + 1) + " attempts");
                    return true;
                }
                if (0 == n) {
                    System.err.println(this.infoPrefix(System.currentTimeMillis()) + " III " + this.getName() + " - Wait for lock");
                }
                Thread.sleep(this.poll_ms);
                ++n;
            } while (0L < (l -= System.currentTimeMillis() - l2));
        }
        catch (InterruptedException interruptedException) {
            long l5 = System.currentTimeMillis();
            throw new RuntimeException(this.infoPrefix(l5) + " EEE (1) " + this.getName() + " - couldn't get lock within " + (l5 - l3) + " ms, " + n + " attempts", interruptedException);
        }
        l2 = System.currentTimeMillis();
        System.err.println(this.infoPrefix(l2) + " +++ EEE (2) " + this.getName() + " - couldn't get lock within " + (l2 - l3) + " ms, " + n + " attempts");
        return false;
    }

    protected abstract boolean tryLockImpl();

    @Override
    public void unlock() {
        long l = System.currentTimeMillis();
        if (this.locked) {
            this.locked = !this.unlockImpl();
            long l2 = System.currentTimeMillis();
            System.err.println(this.infoPrefix(l2) + " --- " + this.getName() + " - Unlock " + (this.locked ? "failed" : "ok") + " within " + (l2 - l) + " ms");
        }
    }

    protected abstract boolean unlockImpl();

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }

    protected String infoPrefix(long l) {
        return "SLOCK [T " + Thread.currentThread().getName() + " @ " + l + " ms";
    }

    protected String infoPrefix() {
        return this.infoPrefix(System.currentTimeMillis());
    }
}

