/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u0019H$J \u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/JsonContentPolymorphicSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "baseClass", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "selectDeserializer", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonElement;", "throwSubtypeNotRegistered", "", "subClass", "kotlinx-serialization-json"})
public abstract class JsonContentPolymorphicSerializer<T>
implements KSerializer<T> {
    private final KClass<T> baseClass;
    private final SerialDescriptor descriptor;

    public JsonContentPolymorphicSerializer(KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        this.baseClass = kClass;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor$default((String)("JsonContentPolymorphicSerializer<" + this.baseClass.getSimpleName() + '>'), (SerialKind)((SerialKind)PolymorphicKind.SEALED.INSTANCE), (SerialDescriptor[])new SerialDescriptor[0], null, (int)8, null);
    }

    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void serialize(Encoder encoder, T t) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        SerializationStrategy serializationStrategy = encoder.getSerializersModule().getPolymorphic(this.baseClass, t);
        if (serializationStrategy == null) {
            KSerializer kSerializer = SerializersKt.serializerOrNull((KClass)Reflection.getOrCreateKotlinClass(t.getClass()));
            if (kSerializer != null) {
                serializationStrategy = (SerializationStrategy)kSerializer;
            } else {
                this.throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(t.getClass()), this.baseClass);
                throw new KotlinNothingValueException();
            }
        }
        SerializationStrategy serializationStrategy2 = serializationStrategy;
        ((KSerializer)serializationStrategy2).serialize(encoder, t);
    }

    public final T deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"");
        JsonDecoder jsonDecoder = JsonElementSerializersKt.asJsonDecoder(decoder);
        JsonElement jsonElement = jsonDecoder.decodeJsonElement();
        DeserializationStrategy<T> deserializationStrategy = this.selectDeserializer(jsonElement);
        Intrinsics.checkNotNull(deserializationStrategy);
        KSerializer kSerializer = (KSerializer)deserializationStrategy;
        return jsonDecoder.getJson().decodeFromJsonElement((DeserializationStrategy)kSerializer, jsonElement);
    }

    protected abstract DeserializationStrategy<T> selectDeserializer(JsonElement var1);

    private final Void throwSubtypeNotRegistered(KClass<?> kClass, KClass<?> kClass2) {
        String string = kClass.getSimpleName();
        if (string == null) {
            string = String.valueOf(kClass);
        }
        String string2 = string;
        String string3 = "in the scope of '" + kClass2.getSimpleName() + '\'';
        throw new SerializationException("Class '" + string2 + "' is not registered for polymorphic serialization " + string3 + ".\nMark the base class as 'sealed' or register the serializer explicitly.");
    }
}

