/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.InternalJsonReader;
import kotlinx.serialization.json.internal.ReaderJsonLexer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\b\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexerWithComments;", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "consumeNextToken", "", "expected", "", "canConsumeValue", "", "", "peekNextToken", "handleComment", "Lkotlin/Pair;", "", "position", "prefetchWithinThreshold", "skipWhitespaces", "kotlinx-serialization-json"})
public final class ReaderJsonLexerWithComments
extends ReaderJsonLexer {
    public ReaderJsonLexerWithComments(InternalJsonReader internalJsonReader, char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"");
        super(internalJsonReader, cArray);
    }

    @Override
    public void consumeNextToken(char c) {
        this.ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.skipWhitespaces();
        if (n >= arrayAsSequence.length() || n == -1) {
            this.currentPosition = -1;
            this.unexpectedToken(c);
        }
        char c2 = arrayAsSequence.charAt(n);
        this.currentPosition = n + 1;
        if (c2 == c) {
            return;
        }
        this.unexpectedToken(c);
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int n = this.skipWhitespaces();
        if (n >= this.getSource().length() || n == -1) {
            return false;
        }
        return this.isValidValueStart(this.getSource().charAt(n));
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.skipWhitespaces();
        if (n >= arrayAsSequence.length() || n == -1) {
            return 10;
        }
        this.currentPosition = n + 1;
        return AbstractJsonLexerKt.charToTokenClass(arrayAsSequence.charAt(n));
    }

    @Override
    public byte peekNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.skipWhitespaces();
        if (n >= arrayAsSequence.length() || n == -1) {
            return 10;
        }
        this.currentPosition = n;
        return AbstractJsonLexerKt.charToTokenClass(arrayAsSequence.charAt(n));
    }

    private final Pair<Integer, Boolean> handleComment(int n) {
        int n2 = n;
        int n3 = n2 + 2;
        switch (this.getSource().charAt(n2 + 1)) {
            case '/': {
                while (n2 != -1) {
                    n2 = StringsKt.indexOf$default((CharSequence)this.getSource(), (char)'\n', (int)n3, (boolean)false, (int)4, null);
                    if (n2 == -1) {
                        n3 = n2 = this.prefetchOrEof(this.getSource().length());
                        continue;
                    }
                    return TuplesKt.to((Object)(n2 + 1), (Object)true);
                }
                return TuplesKt.to((Object)-1, (Object)true);
            }
            case '*': {
                boolean bl = false;
                while (n2 != -1) {
                    n2 = StringsKt.indexOf$default((CharSequence)this.getSource(), (String)"*/", (int)n3, (boolean)false, (int)4, null);
                    if (n2 != -1) {
                        return TuplesKt.to((Object)(n2 + 2), (Object)true);
                    }
                    if (this.getSource().charAt(this.getSource().length() - 1) != '*') {
                        n3 = n2 = this.prefetchOrEof(this.getSource().length());
                        continue;
                    }
                    n2 = this.prefetchWithinThreshold(this.getSource().length() - 1);
                    if (bl) break;
                    bl = true;
                    n3 = n2;
                }
                this.currentPosition = this.getSource().length();
                AbstractJsonLexer.fail$default(this, "Expected end of the block comment: \"*/\", but had EOF instead", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        return TuplesKt.to((Object)n2, (Object)false);
    }

    private final int prefetchWithinThreshold(int n) {
        if (this.getSource().length() - n > this.threshold) {
            return n;
        }
        this.currentPosition = n;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int skipWhitespaces() {
        int n = this.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            int n2 = this.getSource().charAt(n);
            Pair<Integer, Boolean> pair = (Pair<Integer, Boolean>)this;
            int n3 = n2;
            boolean bl = false;
            if (n3 == 32 || n3 == 10 || n3 == 13 || n3 == 9) {
                ++n;
                continue;
            }
            if (n2 != 47 || n + 1 >= this.getSource().length()) break;
            pair = this.handleComment(n);
            n3 = ((Number)pair.component1()).intValue();
            bl = (Boolean)pair.component2();
            n = n3;
            if (bl) continue;
            break;
        }
        this.currentPosition = n;
        return n;
    }
}

