/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J)\u0010'\u001a\u00020\u001f\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0006\u0010+\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001cH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u00103\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J?\u00104\u001a\u00020\u001f\"\b\b\u0000\u0010(*\u0002052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\b\u0010+\u001a\u0004\u0018\u0001H(H\u0016\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020$H\u0016JR\u00109\u001a\u0002H(\"\n\b\u0000\u0010(\u0018\u0001*\u00020\u000426\u0010:\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(>\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u0002H(0;H\u0082\b\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001aH\u0016J\u0010\u0010B\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020&H\u0016J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0018\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "composer", "Lkotlinx/serialization/json/internal/Composer;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "modeReuseCache", "", "<init>", "(Lkotlinx/serialization/json/internal/Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "output", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "(Lkotlinx/serialization/json/internal/InternalJsonWriter;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "getJson", "()Lkotlinx/serialization/json/Json;", "[Lkotlinx/serialization/json/JsonEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "forceQuoting", "", "polymorphicDiscriminator", "", "polymorphicSerialName", "encodeJsonElement", "", "element", "Lkotlinx/serialization/json/JsonElement;", "shouldEncodeElementDefault", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTypeInfo", "discriminator", "serialName", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endStructure", "encodeElement", "encodeNullableSerializableElement", "", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "composerAs", "composerCreator", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "writer", "(Lkotlin/jvm/functions/Function2;)Lkotlinx/serialization/json/internal/Composer;", "encodeNull", "encodeBoolean", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeString", "encodeEnum", "enumDescriptor", "kotlinx-serialization-json"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    private final Composer composer;
    private final Json json;
    private final WriteMode mode;
    private final JsonEncoder[] modeReuseCache;
    private final SerializersModule serializersModule;
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    private String polymorphicDiscriminator;
    private String polymorphicSerialName;

    public StreamingJsonEncoder(Composer composer, Json json, WriteMode writeMode, JsonEncoder[] jsonEncoderArray) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        this.composer = composer;
        this.json = json;
        this.mode = writeMode;
        this.modeReuseCache = jsonEncoderArray;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int n = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[n] != null || this.modeReuseCache[n] != this)) {
            this.modeReuseCache[n] = this;
        }
    }

    @Override
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(InternalJsonWriter internalJsonWriter, Json json, WriteMode writeMode, JsonEncoder[] jsonEncoderArray) {
        Intrinsics.checkNotNullParameter((Object)internalJsonWriter, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonEncoderArray, (String)"");
        this(ComposersKt.Composer(internalJsonWriter, json), json, writeMode, jsonEncoderArray);
    }

    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public void encodeJsonElement(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        if (this.polymorphicDiscriminator != null && !(jsonElement instanceof JsonObject)) {
            PolymorphicKt.throwJsonElementPolymorphicException(this.polymorphicSerialName, jsonElement);
            throw new KotlinNothingValueException();
        }
        this.encodeSerializableValue((SerializationStrategy)JsonElementSerializer.INSTANCE, jsonElement);
    }

    public boolean shouldEncodeElementDefault(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return this.configuration.getEncodeDefaults();
    }

    public <T> void encodeSerializableValue(SerializationStrategy<? super T> serialKind, T t) {
        Intrinsics.checkNotNullParameter(serialKind, (String)"");
        JsonEncoder jsonEncoder = this;
        boolean bl = false;
        if (jsonEncoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serialKind.serialize((Encoder)jsonEncoder, t);
        } else {
            SerialKind serialKind2;
            SerialKind serialKind3;
            String string;
            SerialKind serialKind4;
            boolean bl2;
            boolean bl3 = serialKind instanceof AbstractPolymorphicSerializer;
            if (bl3) {
                bl2 = jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
            } else {
                switch (PolymorphicKt.WhenMappings.$EnumSwitchMapping$0[jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                    case 1: 
                    case 2: {
                        bl2 = false;
                        break;
                    }
                    case 3: {
                        serialKind4 = serialKind.getDescriptor().getKind();
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)serialKind4, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind4, (Object)StructureKind.OBJECT.INSTANCE)) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean bl5 = bl2;
            String string2 = string = bl5 ? PolymorphicKt.classDiscriminator(serialKind.getDescriptor(), jsonEncoder.getJson()) : null;
            if (bl3) {
                AbstractPolymorphicSerializer abstractPolymorphicSerializer = (AbstractPolymorphicSerializer)serialKind;
                if (t == null) {
                    boolean bl6 = false;
                    String string3 = "Value for serializer " + ((AbstractPolymorphicSerializer)serialKind).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                    throw new IllegalArgumentException(string3.toString());
                }
                serialKind4 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)abstractPolymorphicSerializer, (Encoder)jsonEncoder, t);
                if (string != null) {
                    PolymorphicKt.access$validateIfSealed((SerializationStrategy)serialKind, (SerializationStrategy)serialKind4, string);
                    PolymorphicKt.checkKind(serialKind4.getDescriptor().getKind());
                }
                Intrinsics.checkNotNull((Object)serialKind4);
                serialKind3 = serialKind4;
            } else {
                serialKind3 = serialKind2 = serialKind;
            }
            if (string != null) {
                String string4 = serialKind2.getDescriptor().getSerialName();
                String string5 = string;
                boolean bl7 = false;
                this.polymorphicDiscriminator = string5;
                this.polymorphicSerialName = string4;
            }
            serialKind2.serialize((Encoder)jsonEncoder, t);
        }
    }

    private final void encodeTypeInfo(String string, String string2) {
        this.composer.nextItem();
        this.encodeString(string);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(string2);
    }

    public CompositeEncoder beginStructure(SerialDescriptor serialDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        WriteMode writeMode = WriteModeKt.switchMode(this.getJson(), serialDescriptor);
        if (writeMode.begin != '\u0000') {
            this.composer.print(writeMode.begin);
            this.composer.indent();
        }
        if ((string = this.polymorphicDiscriminator) != null) {
            String string2 = this.polymorphicSerialName;
            if (string2 == null) {
                string2 = serialDescriptor.getSerialName();
            }
            this.encodeTypeInfo(string, string2);
            this.polymorphicDiscriminator = null;
            this.polymorphicSerialName = null;
        }
        if (this.mode == writeMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[writeMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), writeMode, this.modeReuseCache);
    }

    public void endStructure(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItemIfNotFirst();
            this.composer.print(this.mode.end);
        }
    }

    public boolean encodeElement(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (n % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (n == 0) {
                    this.forceQuoting = true;
                }
                if (n != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(JsonNamesMapKt.getJsonElementName(serialDescriptor, this.getJson(), n));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    public <T> void encodeNullableSerializableElement(SerialDescriptor serialDescriptor, int n, SerializationStrategy<? super T> serializationStrategy, T t) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(serializationStrategy, (String)"");
        if (t != null || this.configuration.getExplicitNulls()) {
            super.encodeNullableSerializableElement(serialDescriptor, n, serializationStrategy, t);
        }
    }

    public Encoder encodeInline(SerialDescriptor serialDescriptor) {
        Encoder encoder;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (StreamingJsonEncoderKt.isUnsignedNumber(serialDescriptor)) {
            Composer composer;
            StreamingJsonEncoder streamingJsonEncoder = this;
            boolean bl = false;
            if (streamingJsonEncoder.composer instanceof ComposerForUnsignedNumbers) {
                composer = streamingJsonEncoder.composer;
            } else {
                boolean bl2 = streamingJsonEncoder.forceQuoting;
                InternalJsonWriter internalJsonWriter = streamingJsonEncoder.composer.writer;
                boolean bl3 = false;
                composer = new ComposerForUnsignedNumbers(internalJsonWriter, bl2);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer2 = composer;
            encoder = new StreamingJsonEncoder(composer2, json, writeMode, jsonEncoderArray);
        } else if (StreamingJsonEncoderKt.isUnquotedLiteral(serialDescriptor)) {
            Composer composer;
            StreamingJsonEncoder streamingJsonEncoder = this;
            boolean bl = false;
            if (streamingJsonEncoder.composer instanceof ComposerForUnquotedLiterals) {
                composer = streamingJsonEncoder.composer;
            } else {
                boolean bl4 = streamingJsonEncoder.forceQuoting;
                InternalJsonWriter internalJsonWriter = streamingJsonEncoder.composer.writer;
                boolean bl5 = false;
                composer = new ComposerForUnquotedLiterals(internalJsonWriter, bl4);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer3 = composer;
            encoder = new StreamingJsonEncoder(composer3, json, writeMode, jsonEncoderArray);
        } else if (this.polymorphicDiscriminator != null) {
            StreamingJsonEncoder streamingJsonEncoder;
            StreamingJsonEncoder streamingJsonEncoder2 = streamingJsonEncoder = this;
            boolean bl = false;
            streamingJsonEncoder2.polymorphicSerialName = serialDescriptor.getSerialName();
            encoder = streamingJsonEncoder;
        } else {
            encoder = super.encodeInline(serialDescriptor);
        }
        return encoder;
    }

    private final /* synthetic */ <T extends Composer> T composerAs(Function2<? super InternalJsonWriter, ? super Boolean, ? extends T> function2) {
        boolean bl = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        return (T)(this.composer instanceof Composer ? this.composer : (Composer)function2.invoke((Object)this.composer.writer, (Object)this.forceQuoting));
    }

    public void encodeNull() {
        this.composer.print("null");
    }

    public void encodeBoolean(boolean bl) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(bl));
        } else {
            this.composer.print(bl);
        }
    }

    public void encodeByte(byte by) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(by));
        } else {
            this.composer.print(by);
        }
    }

    public void encodeShort(short s) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(s));
        } else {
            this.composer.print(s);
        }
    }

    public void encodeInt(int n) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(n));
        } else {
            this.composer.print(n);
        }
    }

    public void encodeLong(long l) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(l));
        } else {
            this.composer.print(l);
        }
    }

    public void encodeFloat(float f) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(f));
        } else {
            this.composer.print(f);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(Math.abs(f) <= Float.MAX_VALUE)) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(f), this.composer.writer.toString());
        }
    }

    public void encodeDouble(double d) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(d));
        } else {
            this.composer.print(d);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(Math.abs(d) <= Double.MAX_VALUE)) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(d, this.composer.writer.toString());
        }
    }

    public void encodeChar(char c) {
        this.encodeString(String.valueOf(c));
    }

    public void encodeString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.composer.printQuoted(string);
    }

    public void encodeEnum(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        this.encodeString(serialDescriptor.getElementName(n));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

