/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonFriendModuleApi;
import kotlinx.serialization.json.internal.JsonPrimitiveDecoder;
import kotlinx.serialization.json.internal.JsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonTreeListDecoder;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a5\u0010\t\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"readJson", "T", "json", "Lkotlinx/serialization/json/Json;", "element", "Lkotlinx/serialization/json/JsonElement;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "readPolymorphicJson", "discriminator", "", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "kotlinx-serialization-json"})
public final class TreeJsonDecoderKt {
    @JsonFriendModuleApi
    public static final <T> T readJson(Json json, JsonElement jsonElement, DeserializationStrategy<? extends T> deserializationStrategy) {
        AbstractJsonTreeDecoder abstractJsonTreeDecoder;
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        JsonElement jsonElement2 = jsonElement;
        if (jsonElement2 instanceof JsonObject) {
            abstractJsonTreeDecoder = new JsonTreeDecoder(json, (JsonObject)jsonElement, null, null, 12, null);
        } else if (jsonElement2 instanceof JsonArray) {
            abstractJsonTreeDecoder = new JsonTreeListDecoder(json, (JsonArray)jsonElement);
        } else if (jsonElement2 instanceof JsonLiteral || Intrinsics.areEqual((Object)jsonElement2, (Object)JsonNull.INSTANCE)) {
            abstractJsonTreeDecoder = new JsonPrimitiveDecoder(json, (JsonPrimitive)jsonElement, null, 4, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AbstractJsonTreeDecoder abstractJsonTreeDecoder2 = abstractJsonTreeDecoder;
        return abstractJsonTreeDecoder2.decodeSerializableValue(deserializationStrategy);
    }

    public static final <T> T readPolymorphicJson(Json json, String string, JsonObject jsonObject, DeserializationStrategy<? extends T> deserializationStrategy) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        return new JsonTreeDecoder(json, jsonObject, string, deserializationStrategy.getDescriptor()).decodeSerializableValue(deserializationStrategy);
    }
}

