/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001aS\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0007*\u0002H\u0006\"\b\b\u0002\u0010\b*\u0002H\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"switchMode", "Lkotlinx/serialization/json/internal/WriteMode;", "Lkotlinx/serialization/json/Json;", "desc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "selectMapMode", "T", "R1", "R2", "mapDescriptor", "ifMap", "Lkotlin/Function0;", "ifList", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "carrierDescriptor", "module", "Lkotlinx/serialization/modules/SerializersModule;", "kotlinx-serialization-json"})
public final class WriteModeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final WriteMode switchMode(Json json, SerialDescriptor serialDescriptor) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        SerialKind serialKind = serialDescriptor.getKind();
        if (serialKind instanceof PolymorphicKind) {
            writeMode = WriteMode.POLY_OBJ;
            return writeMode;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            writeMode = WriteMode.LIST;
            return writeMode;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Json json2 = json;
            boolean bl = false;
            SerialDescriptor serialDescriptor2 = WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), json2.getSerializersModule());
            SerialKind serialKind2 = serialDescriptor2.getKind();
            if (serialKind2 instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind2, (Object)SerialKind.ENUM.INSTANCE)) {
                boolean bl2 = false;
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                if (!json2.getConfiguration().getAllowStructuredMapKeys()) throw JsonExceptionsKt.InvalidKeyKindException(serialDescriptor2);
                boolean bl3 = false;
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    public static final <T, R1 extends T, R2 extends T> T selectMapMode(Json json, SerialDescriptor serialDescriptor, Function0<? extends R1> function0, Function0<? extends R2> function02) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter(function02, (String)"");
        boolean bl = false;
        SerialDescriptor serialDescriptor2 = WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), json.getSerializersModule());
        SerialKind serialKind = serialDescriptor2.getKind();
        if (serialKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
            object = function0.invoke();
        } else if (json.getConfiguration().getAllowStructuredMapKeys()) {
            object = function02.invoke();
        } else {
            throw JsonExceptionsKt.InvalidKeyKindException(serialDescriptor2);
        }
        return (T)object;
    }

    public static final SerialDescriptor carrierDescriptor(SerialDescriptor serialDescriptor, SerializersModule serializersModule) {
        SerialDescriptor serialDescriptor2;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"");
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            serialDescriptor2 = ContextAwareKt.getContextualDescriptor((SerializersModule)serializersModule, (SerialDescriptor)serialDescriptor);
            if (serialDescriptor2 == null || (serialDescriptor2 = WriteModeKt.carrierDescriptor(serialDescriptor2, serializersModule)) == null) {
                serialDescriptor2 = serialDescriptor;
            }
        } else {
            serialDescriptor2 = serialDescriptor.isInline() ? WriteModeKt.carrierDescriptor(serialDescriptor.getElementDescriptor(0), serializersModule) : serialDescriptor;
        }
        return serialDescriptor2;
    }
}

