/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ClassLoadersKt;
import io.ktor.server.engine.EmbeddedServerJvmKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.OverridingClassLoader;
import io.ktor.server.engine.ServerHostUtilsKt;
import io.ktor.server.engine.ShutdownHookKt;
import io.ktor.server.engine.internal.ApplicationUtilsJvmKt;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import io.ktor.server.engine.internal.CallableUtilsKt;
import io.ktor.server.engine.internal.EngineUtilsJvmKt;
import io.ktor.server.engine.internal.ReloadingException;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.text.StringsKt;
import kotlinx.b.u;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.J;
import kotlinx.coroutines.Z;
import kotlinx.coroutines.i;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0004*\u00020\u00032\u00020\u0005B>\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010!\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b$\u0010\u0011J\u001d\u0010'\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J&\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)H\u0086@\u00a2\u0006\u0004\b-\u0010.J%\u00104\u001a\u00020\u000b2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J!\u00104\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/\u00a2\u0006\u0004\b4\u00108J$\u00109\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/H\u0086@\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010<\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b<\u0010=J'\u0010A\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020>2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010E\u001a\u00020\u000b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0CH\u0002\u00a2\u0006\u0004\bE\u0010FJ%\u0010H\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020>2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0CH\u0002\u00a2\u0006\u0004\bH\u0010IJ\u000f\u0010J\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bJ\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010KR\u0017\u0010M\u001a\u00020L8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0017\u0010R\u001a\u00020Q8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010UR\u0011\u0010!\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u0014R\u0017\u0010W\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u0014\u0010\\\u001a\u00020[8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0018\u0010`\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u001c\u0010c\u001a\b\u0012\u0004\u0012\u00020b0\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010dR\u001a\u0010f\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bf\u0010dR\u001a\u0010g\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bg\u0010dR\u001a\u0010h\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010dR\u0018\u0010i\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0017\u0010k\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\bk\u0010l\u001a\u0004\bm\u0010nR\u001d\u0010t\u001a\u0004\u0018\u00010o8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\u00a8\u0006u"}, d2={"Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/engine/ApplicationEngine;", "TEngine", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "TConfiguration", "", "Lio/ktor/server/application/ServerConfig;", "rootConfig", "Lio/ktor/server/engine/ApplicationEngineFactory;", "engineFactory", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "engineConfigBlock", "<init>", "(Lio/ktor/server/application/ServerConfig;Lio/ktor/server/engine/ApplicationEngineFactory;Lkotlin/jvm/functions/Function1;)V", "reload", "()V", "Lio/ktor/server/application/Application;", "currentApplication", "()Lio/ktor/server/application/Application;", "", "Ljava/nio/file/WatchEvent;", "getFileChanges", "()Ljava/util/List;", "Lkotlin/Pair;", "Ljava/lang/ClassLoader;", "createApplication", "()Lkotlin/Pair;", "createClassLoader", "()Ljava/lang/ClassLoader;", "Lio/ktor/events/EventDefinition;", "event", "application", "safeRaiseEvent", "(Lio/ktor/events/EventDefinition;Lio/ktor/server/application/Application;)V", "destroyApplication", "Ljava/net/URL;", "urls", "watchUrls", "(Ljava/util/List;)V", "", "wait", "start", "(Z)Lio/ktor/server/engine/EmbeddedServer;", "startSuspend", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "shutdownGracePeriod", "shutdownTimeout", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "stop", "(JJLjava/util/concurrent/TimeUnit;)V", "gracePeriodMillis", "timeoutMillis", "(JJ)V", "stopSuspend", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "currentClassLoader", "instantiateAndConfigureApplication", "(Ljava/lang/ClassLoader;)Lio/ktor/server/application/Application;", "", "name", "newInstance", "launchModuleByName", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lio/ktor/server/application/Application;)V", "Lkotlin/Function0;", "block", "avoidingDoubleStartup", "(Lkotlin/jvm/functions/Function0;)V", "fqName", "avoidingDoubleStartupFor", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "cleanupWatcher", "Lio/ktor/server/application/ServerConfig;", "Lio/ktor/events/Events;", "monitor", "Lio/ktor/events/Events;", "getMonitor", "()Lio/ktor/events/Events;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "getApplication", "engineConfig", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "getEngineConfig", "()Lio/ktor/server/engine/ApplicationEngine$Configuration;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "applicationInstanceLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "recreateInstance", "Z", "applicationClassLoader", "Ljava/lang/ClassLoader;", "Ljava/nio/file/WatchKey;", "packageWatchKeys", "Ljava/util/List;", "configuredWatchPath", "watchPatterns", "configModulesNames", "modulesNames", "applicationInstance", "Lio/ktor/server/application/Application;", "engine", "Lio/ktor/server/engine/ApplicationEngine;", "getEngine", "()Lio/ktor/server/engine/ApplicationEngine;", "Ljava/nio/file/WatchService;", "watcher$delegate", "Lkotlin/Lazy;", "getWatcher", "()Ljava/nio/file/WatchService;", "watcher", "ktor-server-core"})
public final class EmbeddedServer<TEngine extends ApplicationEngine, TConfiguration extends ApplicationEngine.Configuration> {
    private final ServerConfig rootConfig;
    private final Events monitor;
    private final ApplicationEnvironment environment;
    private final TConfiguration engineConfig;
    private final ReentrantReadWriteLock applicationInstanceLock;
    private boolean recreateInstance;
    private ClassLoader applicationClassLoader;
    private List<? extends WatchKey> packageWatchKeys;
    private final List<String> configuredWatchPath;
    private final List<String> watchPatterns;
    private final List<String> configModulesNames;
    private final List<String> modulesNames;
    private Application applicationInstance;
    private final TEngine engine;
    private final Lazy watcher$delegate;

    public EmbeddedServer(ServerConfig serverConfig, ApplicationEngineFactory<? extends TEngine, TConfiguration> applicationEngineFactory, Function1<? super TConfiguration, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"");
        Intrinsics.checkNotNullParameter(applicationEngineFactory, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.rootConfig = serverConfig;
        this.monitor = this.rootConfig.getEnvironment().getMonitor();
        this.environment = this.rootConfig.getEnvironment();
        this.engineConfig = applicationEngineFactory.configuration(function1);
        this.applicationInstanceLock = new ReentrantReadWriteLock();
        this.packageWatchKeys = CollectionsKt.emptyList();
        ApplicationConfigValue applicationConfigValue = this.environment.getConfig().propertyOrNull("ktor.deployment.watch");
        List list = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.configuredWatchPath = list;
        this.watchPatterns = CollectionsKt.plus((Collection)this.configuredWatchPath, (Iterable)this.rootConfig.getWatchPaths$ktor_server_core());
        EmbeddedServer embeddedServer = this;
        EmbeddedServer embeddedServer2 = this;
        boolean bl = false;
        Object object = embeddedServer.environment.getConfig().propertyOrNull("ktor.application.modules");
        if (object == null || (object = object.getList()) == null) {
            object = CollectionsKt.emptyList();
        }
        embeddedServer2.configModulesNames = object;
        this.modulesNames = this.configModulesNames;
        this.applicationInstance = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((EmbeddedServer)this.receiver).getEngine();
            }
        }));
        this.engine = applicationEngineFactory.create(this.environment, this.monitor, this.rootConfig.getDevelopmentMode(), this.engineConfig, (Function0<Application>)((Function0)new Function0<Application>((Object)this){

            public final Application invoke() {
                return EmbeddedServer.access$currentApplication((EmbeddedServer)this.receiver);
            }
        }));
        this.watcher$delegate = LazyKt.lazy(EmbeddedServer::watcher_delegate$lambda$2);
    }

    public /* synthetic */ EmbeddedServer(ServerConfig serverConfig, ApplicationEngineFactory applicationEngineFactory, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = EmbeddedServer::_init_$lambda$0;
        }
        this(serverConfig, applicationEngineFactory, function1);
    }

    public final Events getMonitor() {
        return this.monitor;
    }

    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    public final Application getApplication() {
        return this.currentApplication();
    }

    public final TConfiguration getEngineConfig() {
        return this.engineConfig;
    }

    public final TEngine getEngine() {
        return this.engine;
    }

    private final WatchService getWatcher() {
        Lazy lazy = this.watcher$delegate;
        return (WatchService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Pair<Application, ClassLoader> pair = this.createApplication();
            Application application = (Application)((Object)pair.component1());
            ClassLoader classLoader = (ClassLoader)pair.component2();
            this.applicationInstance = application;
            this.applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Application currentApplication() {
        Application application;
        ReentrantReadWriteLock.ReadLock readLock = this.applicationInstanceLock.readLock();
        readLock.lock();
        try {
            Application application2;
            boolean bl = false;
            Application application3 = this.applicationInstance;
            if (application3 == null) {
                throw new IllegalStateException("EmbeddedServer was stopped".toString());
            }
            Application application4 = application3;
            if (!this.rootConfig.getDevelopmentMode()) {
                application2 = application4;
            } else {
                Object object = this.getFileChanges();
                if (object == null || object.isEmpty()) {
                    application2 = application4;
                } else {
                    object = this.applicationInstanceLock;
                    ReentrantReadWriteLock.ReadLock readLock2 = ((ReentrantReadWriteLock)object).readLock();
                    int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
                    for (int j = 0; j < n; ++j) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        this.destroyApplication();
                        Pair<Application, ClassLoader> pair = this.createApplication();
                        Application application5 = (Application)((Object)pair.component1());
                        ClassLoader classLoader = (ClassLoader)pair.component2();
                        this.applicationInstance = application5;
                        this.applicationClassLoader = classLoader;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int j = 0; j < n; ++j) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    application2 = this.applicationInstance;
                    if (application2 == null) {
                        throw new IllegalStateException("EmbeddedServer was stopped".toString());
                    }
                }
            }
            application = application2;
        }
        finally {
            readLock.unlock();
        }
        return application;
    }

    private final List<WatchEvent<?>> getFileChanges() {
        try {
            Iterable iterable;
            boolean bl;
            Object object;
            Iterable iterable2 = this.packageWatchKeys;
            boolean bl2 = false;
            Iterable iterable3 = iterable2;
            Collection collection = new ArrayList();
            boolean bl3 = false;
            for (Object t : iterable3) {
                Iterator iterator = (WatchKey)t;
                boolean bl4 = false;
                List<WatchEvent<?>> list = iterator.pollEvents();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                iterator = list;
                CollectionsKt.addAll((Collection)collection, (Iterable)((Object)iterator));
            }
            List list = (List)collection;
            if (list.isEmpty()) {
                return list;
            }
            this.environment.getLog().info("Changes in application detected.");
            int n = list.size();
            while (true) {
                Thread.sleep(200L);
                iterable3 = this.packageWatchKeys;
                boolean bl5 = false;
                Iterable<Object> iterable4 = iterable3;
                object = new ArrayList();
                bl = false;
                for (Object t : iterable4) {
                    Object object2 = (WatchKey)t;
                    boolean bl6 = false;
                    List<WatchEvent<?>> list2 = object2.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"");
                    object2 = list2;
                    CollectionsKt.addAll((Collection)object, (Iterable)object2);
                }
                iterable = (List)object;
                if (iterable.isEmpty()) break;
                this.environment.getLog().debug("Waiting for more changes.");
                n += iterable.size();
            }
            this.environment.getLog().debug("Changes to " + n + " files caused application restart.");
            iterable = CollectionsKt.take((Iterable)list, (int)5);
            boolean bl7 = false;
            for (Iterable<Object> iterable4 : iterable) {
                object = (WatchEvent)((Object)iterable4);
                bl = false;
                this.environment.getLog().debug("...  {}", object.context());
            }
            return list;
        }
        catch (InterruptedException interruptedException) {
            this.environment.getLog().debug("Watch service was interrupted", (Throwable)interruptedException);
            return null;
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            this.environment.getLog().debug("Watch service was closed", (Throwable)closedWatchServiceException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Application, ClassLoader> createApplication() {
        ClassLoader classLoader = this.createClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            Pair pair = TuplesKt.to((Object)((Object)this.instantiateAndConfigureApplication(classLoader)), (Object)classLoader);
            return pair;
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ClassLoader createClassLoader() {
        var1_1 = this.environment.getClassLoader();
        if (!this.rootConfig.getDevelopmentMode()) {
            this.environment.getLog().info("Autoreload is disabled because the development mode is off.");
            return var1_1;
        }
        var2_2 = this.watchPatterns;
        if (var2_2.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns specified, automatic reload is not active.");
            return var1_1;
        }
        var3_3 = ClassLoadersKt.allURLs(var1_1);
        var4_4 = new File(System.getProperty("java.home")).getParent();
        var6_5 = var3_3;
        var7_6 = false;
        var8_8 = var6_5;
        var9_9 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var6_5, (int)10));
        var10_11 = false;
        for (Object var12_16 : var8_8) {
            var13_18 = (URL)var12_16;
            var23_22 = var9_9;
            var14_19 = false;
            var23_22.add(var13_18.getFile());
        }
        var5_23 = (List)var9_9;
        this.environment.getLog().debug("Java Home: " + var4_4);
        var6_5 = var5_23;
        var24_24 = new StringBuilder().append("Class Loader: ").append(var1_1).append(": ");
        var23_22 = this.environment.getLog();
        var7_6 = false;
        var8_8 = var6_5;
        var9_9 = new ArrayList<E>();
        var10_11 = false;
        for (Object var12_16 : var8_8) {
            var13_18 = (String)var12_16;
            var14_19 = false;
            v0 = var13_18.toString();
            Intrinsics.checkNotNull((Object)var4_4);
            if (!(StringsKt.startsWith$default((String)v0, (String)var4_4, (boolean)false, (int)2, null) == false)) continue;
            var9_9.add(var12_16);
        }
        var25_25 = (List)var9_9;
        var23_22.debug(var24_24.append(var25_25).toString());
        var7_7 = new Class[]{ApplicationEnvironment.class, Pipeline.class, HttpStatusCode.class, Function1.class, Logger.class, ByteReadChannel.class, u.class, Attributes.class};
        var7_7 = CollectionsKt.listOf((Object[])var7_7);
        var8_8 = new HashSet<E>();
        var9_10 = false;
        var10_12 = var7_7;
        var11_14 = false;
        var12_16 = var10_12.iterator();
        while (var12_16.hasNext()) {
            var14_20 = var13_18 = var12_16.next();
            var15_26 = false;
            var16_28 = (Class)var14_20;
            var17_30 = false;
            if (var16_28.getProtectionDomain().getCodeSource().getLocation() == null) continue;
            var19_34 = false;
            var8_8.add(var18_32);
        }
        var6_5 = (HashSet)var8_8;
        var8_8 = var3_3;
        var9_10 = false;
        var10_12 = var8_8;
        var11_15 = new ArrayList<E>();
        var12_17 = false;
        var13_18 = var10_12.iterator();
        while (var13_18.hasNext()) {
            block13: {
                var14_21 = var13_18.next();
                var15_27 = (URL)var14_21;
                var16_29 = false;
                if (var6_5.contains(var15_27)) ** GOTO lbl-1000
                var17_31 = var2_2;
                var18_33 = false;
                if (var17_31 instanceof Collection && ((Collection)var17_31).isEmpty()) {
                    v1 = false;
                } else {
                    for (T var20_36 : var17_31) {
                        var21_37 = (String)var20_36;
                        var22_38 = false;
                        if (!EmbeddedServerJvmKt.checkUrlMatches(var15_27, var21_37)) continue;
                        v1 = true;
                        break block13;
                    }
                    v1 = false;
                }
            }
            if (!v1) ** GOTO lbl-1000
            v2 = var15_27.getPath();
            if (v2 == null) {
                v2 = "";
            }
            Intrinsics.checkNotNull((Object)var4_4);
            if (!StringsKt.startsWith$default((String)v2, (String)var4_4, (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            var11_15.add(var14_21);
        }
        var7_7 = (List)var11_15;
        if (var7_7.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns match classpath entries, automatic reload is not active");
            return var1_1;
        }
        this.watchUrls((List<URL>)var7_7);
        return new OverridingClassLoader((List<URL>)var7_7, var1_1);
    }

    private final void safeRaiseEvent(EventDefinition<Application> eventDefinition, Application application) {
        EventsKt.raiseCatching$default((Events)this.monitor, eventDefinition, (Object)((Object)application), null, (int)4, null);
    }

    private final void destroyApplication() {
        Application application = this.applicationInstance;
        ClassLoader classLoader = this.applicationClassLoader;
        this.applicationInstance = null;
        this.applicationClassLoader = null;
        if (application != null) {
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopping(), application);
            try {
                application.dispose();
                OverridingClassLoader overridingClassLoader = classLoader instanceof OverridingClassLoader ? (OverridingClassLoader)classLoader : null;
                if (overridingClassLoader != null) {
                    overridingClassLoader.close();
                }
            }
            catch (Throwable throwable) {
                this.environment.getLog().error("Failed to destroy application instance.", throwable);
            }
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopped(), application);
        }
        Iterable iterable = this.packageWatchKeys;
        boolean bl = false;
        for (Object t : iterable) {
            WatchKey watchKey = (WatchKey)t;
            boolean bl2 = false;
            watchKey.cancel();
        }
        this.packageWatchKeys = new ArrayList();
    }

    private final void watchUrls(List<URL> list) {
        WatchEvent.Modifier[] modifierArray;
        Object object;
        Object object2;
        HashSet<Path> hashSet = new HashSet<Path>();
        for (URL uRL : list) {
            Object object3;
            Object object5;
            if (uRL.getPath() == null) continue;
            String object32 = URLDecoder.decode((String)object5, "utf-8");
            object2 = this;
            try {
                object3 = object2;
                boolean bl = false;
                object3 = Result.constructor-impl((Object)new File(object32).toPath());
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object3;
            if ((Path)(Result.isFailure-impl((Object)object2) ? null : object2) == null || !Files.exists((Path)object, new LinkOption[0])) continue;
            SimpleFileVisitor<Path> bl5 = new SimpleFileVisitor<Path>(hashSet){
                final /* synthetic */ HashSet<Path> $paths;
                {
                    this.$paths = hashSet;
                }

                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"");
                    Intrinsics.checkNotNullParameter((Object)basicFileAttributes, (String)"");
                    this.$paths.add(path);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"");
                    Intrinsics.checkNotNullParameter((Object)basicFileAttributes, (String)"");
                    Path path2 = path.getParent();
                    if (path2 != null) {
                        this.$paths.add(path2);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            if (!Files.isDirectory((Path)object, new LinkOption[0])) continue;
            Files.walkFileTree((Path)object, (FileVisitor<? super Path>)bl5);
        }
        WatchEvent.Modifier[] modifierArray2 = hashSet;
        boolean bl = false;
        for (Object e : modifierArray2) {
            object = (Path)e;
            boolean bl2 = false;
            this.environment.getLog().debug("Watching " + object + " for changes.");
        }
        WatchEvent.Modifier modifier2 = AutoReloadUtilsKt.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
        if (modifier2 != null) {
            object = modifier2;
            boolean bl3 = false;
            object2 = new WatchEvent.Modifier[]{object};
            modifierArray = object2;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        modifierArray2 = modifierArray;
        Iterable iterable = hashSet;
        WatchEvent.Modifier[] modifierArray3 = this;
        boolean bl4 = false;
        Iterable iterable2 = iterable;
        object = new ArrayList();
        boolean bl5 = false;
        object2 = iterable2;
        boolean bl6 = false;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            WatchKey watchKey;
            Object t;
            Object t2 = t = iterator.next();
            boolean bl7 = false;
            Path path = (Path)t2;
            boolean bl8 = false;
            if (super.getWatcher() != null) {
                WatchService watchService;
                boolean bl9 = false;
                WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                watchKey = path.register(watchService, kindArray, Arrays.copyOf(modifierArray2, modifierArray2.length));
            } else {
                watchKey = null;
            }
            if (watchKey == null) continue;
            WatchKey watchKey2 = watchKey;
            boolean bl10 = false;
            object.add(watchKey2);
        }
        modifierArray3.packageWatchKeys = (List)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EmbeddedServer<TEngine, TConfiguration> start(boolean bl) {
        ShutdownHookKt.addShutdownHook(this, (Function0<Unit>)((Function0)() -> EmbeddedServer.start$lambda$20(this)));
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            boolean bl2 = false;
            try {
                object = this.createApplication();
            }
            catch (Throwable throwable) {
                this.destroyApplication();
                if (!((Collection)this.watchPatterns).isEmpty()) {
                    this.cleanupWatcher();
                }
                throw throwable;
            }
            Pair<Application, ClassLoader> pair = object;
            object = (Application)((Object)pair.component1());
            ClassLoader classLoader = (ClassLoader)pair.component2();
            this.applicationInstance = object;
            this.applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        i.a((CoroutineScope)J.a((CoroutineContext)this.getApplication().getCoroutineContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.this$0 = embeddedServer;
                super(2, continuation);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getEngine().resolvedConnectors((Continuation<List<EngineConnectorConfig>>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = var1_1;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        var4_5 = false;
                        for (T var6_7 : var2_3) {
                            var7_8 = (EngineConnectorConfig)var6_7;
                            var8_9 = false;
                            var9_10 = EngineUtilsJvmKt.escapeHostname(var7_8.getHost());
                            v1 = var3_4.getEnvironment().getLog();
                            v2 = new StringBuilder().append("Responding at ");
                            v3 = var7_8.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"");
                            v1.info(v2.append(v3).append("://").append(var9_10).append(':').append(var7_8.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.engine.start(bl);
        return this;
    }

    public static /* synthetic */ EmbeddedServer start$default(EmbeddedServer embeddedServer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return embeddedServer.start(bl);
    }

    public final Object startSuspend(boolean bl, Continuation<? super EmbeddedServer<TEngine, TConfiguration>> continuation) {
        return i.a((CoroutineContext)((CoroutineContext)ApplicationUtilsJvmKt.getIOBridge(Z.a)), (Function2)new Function2<CoroutineScope, Continuation<? super EmbeddedServer<TEngine, TConfiguration>>, Object>(this, bl, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ boolean $wait;
            {
                this.this$0 = embeddedServer;
                this.$wait = bl;
                super(2, continuation);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return this.this$0.start(this.$wait);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super EmbeddedServer<TEngine, TConfiguration>> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }, continuation);
    }

    public static /* synthetic */ Object startSuspend$default(EmbeddedServer embeddedServer, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return embeddedServer.startSuspend(bl, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(long l2, long l3, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        try {
            this.engine.stop(timeUnit.toMillis(l2), timeUnit.toMillis(l3));
        }
        catch (Exception exception) {
            this.environment.getLog().warn("Exception occurred during engine shutdown", (Throwable)exception);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (!((Collection)this.watchPatterns).isEmpty()) {
            this.cleanupWatcher();
        }
    }

    public final void stop(long l2, long l3) {
        this.stop(l2, l3, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void stop$default(EmbeddedServer embeddedServer, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l3 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        embeddedServer.stop(l2, l3);
    }

    public final Object stopSuspend(long l2, long l3, Continuation<? super Unit> continuation) {
        Object object = i.a((CoroutineContext)((CoroutineContext)ApplicationUtilsJvmKt.getIOBridge(Z.a)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, l2, l3, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ long $gracePeriodMillis;
            final /* synthetic */ long $timeoutMillis;
            {
                this.this$0 = embeddedServer;
                this.$gracePeriodMillis = l2;
                this.$timeoutMillis = l3;
                super(2, continuation);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.stop(this.$gracePeriodMillis, this.$timeoutMillis);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object stopSuspend$default(EmbeddedServer embeddedServer, long l2, long l3, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l3 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        return embeddedServer.stopSuspend(l2, l3, (Continuation<Unit>)continuation);
    }

    private final Application instantiateAndConfigureApplication(ClassLoader classLoader) {
        Application application;
        if (this.recreateInstance || this.applicationInstance == null) {
            application = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

                public Object get() {
                    return ((EmbeddedServer)this.receiver).getEngine();
                }
            }));
        } else {
            this.recreateInstance = true;
            Application application2 = this.applicationInstance;
            application = application2;
            Intrinsics.checkNotNull((Object)((Object)application2));
        }
        Application application3 = application;
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarting(), application3);
        this.avoidingDoubleStartup((Function0<Unit>)((Function0)() -> EmbeddedServer.instantiateAndConfigureApplication$lambda$25(this, classLoader, application3)));
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarted(), application3);
        return application3;
    }

    private final void launchModuleByName(String string, ClassLoader classLoader, Application application) {
        this.avoidingDoubleStartupFor(string, (Function0<Unit>)((Function0)() -> EmbeddedServer.launchModuleByName$lambda$26(classLoader, string, application)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartup(Function0<Unit> function0) {
        try {
            function0.invoke();
        }
        finally {
            List<String> list = AutoReloadUtilsKt.getCurrentStartupModules().get();
            if (list != null) {
                List<String> list2 = list;
                boolean bl = false;
                if (list2.isEmpty()) {
                    AutoReloadUtilsKt.getCurrentStartupModules().remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartupFor(String string, Function0<Unit> function0) {
        List list;
        ThreadLocal<List<String>> threadLocal = AutoReloadUtilsKt.getCurrentStartupModules();
        List list2 = threadLocal.get();
        if (list2 == null) {
            List list3;
            boolean bl = false;
            List list4 = list3 = (List)new ArrayList(1);
            threadLocal.set(list4);
            list2 = list3;
        }
        if (!(!(list = list2).contains(string))) {
            boolean bl = false;
            String string2 = "Module startup is already in progress for function " + string + " (recursive module startup from module main?)";
            throw new IllegalStateException(string2.toString());
        }
        list.add((String)string);
        try {
            function0.invoke();
        }
        finally {
            list.remove(string);
        }
    }

    private final void cleanupWatcher() {
        EmbeddedServer embeddedServer = this;
        try {
            Unit unit;
            Object object = embeddedServer;
            boolean bl = false;
            WatchService watchService = ((EmbeddedServer)object).getWatcher();
            if (watchService != null) {
                watchService.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final Unit _init_$lambda$0(ApplicationEngine.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"");
        return Unit.INSTANCE;
    }

    private static final WatchService watcher_delegate$lambda$2() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            watchService = null;
        }
        return watchService;
    }

    private static final Unit start$lambda$20(EmbeddedServer embeddedServer) {
        EmbeddedServer.stop$default(embeddedServer, 0L, 0L, 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit instantiateAndConfigureApplication$lambda$25(EmbeddedServer embeddedServer, ClassLoader classLoader, Application application) {
        boolean bl;
        String string;
        Iterable iterable = embeddedServer.modulesNames;
        boolean bl2 = false;
        for (Object t : iterable) {
            string = (String)t;
            bl = false;
            embeddedServer.launchModuleByName(string, classLoader, application);
        }
        iterable = embeddedServer.rootConfig.getModules$ktor_server_core();
        bl2 = false;
        for (Object t : iterable) {
            string = (Function1)t;
            bl = false;
            String string2 = ServerHostUtilsKt.methodName((Function)string);
            try {
                embeddedServer.launchModuleByName(string2, classLoader, application);
            }
            catch (ReloadingException reloadingException) {
                string.invoke((Object)application);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit launchModuleByName$lambda$26(ClassLoader classLoader, String string, Application application) {
        CallableUtilsKt.executeModuleFunction(classLoader, string, application);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Application access$currentApplication(EmbeddedServer embeddedServer) {
        return embeddedServer.currentApplication();
    }
}

