/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import io.ktor.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0096@\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "Lkotlin/text/Regex;", "regex", "<init>", "(Lkotlin/text/Regex;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/text/MatchResult;", "result", "lastSlashPosition", "", "prefix", "countSegments", "(Lkotlin/text/MatchResult;ILjava/lang/String;)I", "toString", "()Ljava/lang/String;", "Lkotlin/text/Regex;", "Companion", "ktor-server-core"})
public final class PathSegmentRegexRouteSelector
extends RouteSelector {
    public static final Companion Companion = new Companion(null);
    private final Regex regex;
    private static final Regex GROUP_NAME_MATCHER = PlatformUtils.INSTANCE.getIS_JS() ? new Regex("(^|[^\\\\])\\(\\?<(\\p{L}[\\p{L}\\p{N}]*)>(.*?[^\\\\])?\\)") : new Regex("(^|[^\\\\])\\(\\?<(\\p{Alpha}\\p{Alnum}*)>(.*?[^\\\\])?\\)");

    public PathSegmentRegexRouteSelector(Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"");
        this.regex = regex;
    }

    @Override
    public Object evaluate(RoutingResolveContext routingResolveContext, int n, Continuation<? super RouteSelectorEvaluation> continuation) {
        ParametersBuilder parametersBuilder;
        int n2;
        String string = StringsKt.startsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.regex.getPattern(), (String)"\\/", (boolean)false, (int)2, null) ? "/" : "";
        String string2 = StringsKt.endsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) && IgnoreTrailingSlashKt.getIgnoreTrailingSlash(routingResolveContext.getCall()) ? "/" : "";
        String string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)routingResolveContext.getSegments(), (int)n), (CharSequence)"/", (CharSequence)string, (CharSequence)string2, (int)0, null, null, (int)56, null);
        MatchResult matchResult = Regex.find$default((Regex)this.regex, (CharSequence)string3, (int)0, (int)2, null);
        if (matchResult == null) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        MatchResult matchResult2 = matchResult;
        int n3 = matchResult2.getValue().length();
        boolean bl = false;
        if (string3.length() == n3) {
            n2 = routingResolveContext.getSegments().size() - n;
        } else if (string3.charAt(n3) == '/') {
            n2 = this.countSegments(matchResult2, n3, string);
        } else if (n3 >= 1 && string3.charAt(n3 - 1) == '/') {
            n2 = this.countSegments(matchResult2, n3 - 1, string);
        } else {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        int n4 = n2;
        MatchGroupCollection matchGroupCollection = matchResult2.getGroups();
        Intrinsics.checkNotNull((Object)matchGroupCollection);
        MatchNamedGroupCollection matchNamedGroupCollection = (MatchNamedGroupCollection)matchGroupCollection;
        Parameters.Companion companion = Parameters.Companion;
        boolean bl2 = false;
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
        boolean bl3 = false;
        Sequence sequence = Regex.findAll$default((Regex)GROUP_NAME_MATCHER, (CharSequence)this.regex.getPattern(), (int)0, (int)2, null);
        boolean bl4 = false;
        for (Object e2 : sequence) {
            MatchResult matchResult3 = (MatchResult)e2;
            boolean bl5 = false;
            String string4 = (String)matchResult3.getDestructured().getMatch().getGroupValues().get(2);
            Object object = matchNamedGroupCollection.get(string4);
            if (object == null || (object = object.getValue()) == null) {
                object = "";
            }
            Object object2 = object;
            parametersBuilder2.append(string4, (String)object2);
        }
        Parameters parameters = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters, n4);
    }

    private final int countSegments(MatchResult matchResult, int n, String string) {
        String string2 = matchResult.getValue().substring(0, n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        CharSequence charSequence = string3;
        boolean bl = false;
        int n2 = 0;
        for (int k = 0; k < charSequence.length(); ++k) {
            char c2;
            char c3 = c2 = charSequence.charAt(k);
            boolean bl2 = false;
            if (!(c3 == '/')) continue;
            ++n2;
        }
        int n3 = n2;
        return Intrinsics.areEqual((Object)string, (Object)"/") ? n3 : n3 + 1;
    }

    public String toString() {
        return "Regex(" + this.regex.getPattern() + ')';
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "GROUP_NAME_MATCHER", "Lkotlin/text/Regex;", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

