/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.charset.Charset;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class PointerPointer<P extends Pointer>
extends Pointer {
    private static final Logger logger;
    private P[] pointerArray;

    public PointerPointer(String ... stringArray) {
        this(stringArray.length);
        this.putString(stringArray);
    }

    public PointerPointer(String[] stringArray, String string) {
        this(stringArray.length);
        this.putString(stringArray, string);
    }

    public PointerPointer(String[] stringArray, Charset charset) {
        this(stringArray.length);
        this.putString(stringArray, charset);
    }

    public PointerPointer(P ... PArray) {
        this(PArray.length);
        this.put((Pointer[])PArray);
    }

    public PointerPointer(byte[] ... byArray) {
        this(byArray.length);
        this.put(byArray);
    }

    public PointerPointer(short[] ... sArray) {
        this(sArray.length);
        this.put(sArray);
    }

    public PointerPointer(int[] ... nArray) {
        this(nArray.length);
        this.put(nArray);
    }

    public PointerPointer(long[] ... lArray) {
        this(lArray.length);
        this.put(lArray);
    }

    public PointerPointer(float[] ... fArray) {
        this(fArray.length);
        this.put(fArray);
    }

    public PointerPointer(double[] ... dArray) {
        this(dArray.length);
        this.put(dArray);
    }

    public PointerPointer(char[] ... cArray) {
        this(cArray.length);
        this.put(cArray);
    }

    public PointerPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new PointerPointer(" + l + "): totalBytes = " + PointerPointer.formatBytes(PointerPointer.totalBytes()) + ", physicalBytes = " + PointerPointer.formatBytes(PointerPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public PointerPointer() {
    }

    public PointerPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public PointerPointer<P> position(long l) {
        return (PointerPointer)super.position(l);
    }

    public PointerPointer<P> limit(long l) {
        return (PointerPointer)super.limit(l);
    }

    public PointerPointer<P> capacity(long l) {
        return (PointerPointer)super.capacity(l);
    }

    public PointerPointer<P> getPointer(long l) {
        return (PointerPointer)new PointerPointer<P>(this).offsetAddress(l);
    }

    public String getString(long l) {
        BytePointer bytePointer = this.get(BytePointer.class, l);
        return bytePointer != null ? bytePointer.getString() : null;
    }

    public String getString(long l, String string) {
        BytePointer bytePointer = this.get(BytePointer.class, l);
        return bytePointer != null ? bytePointer.getString(string) : null;
    }

    public String getString(long l, Charset charset) {
        BytePointer bytePointer = this.get(BytePointer.class, l);
        return bytePointer != null ? bytePointer.getString(charset) : null;
    }

    public PointerPointer<P> putString(String ... stringArray) {
        this.pointerArray = new BytePointer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.pointerArray[i] = stringArray[i] != null ? new BytePointer(stringArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> putString(String[] stringArray, String string) {
        this.pointerArray = new BytePointer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.pointerArray[i] = stringArray[i] != null ? new BytePointer(stringArray[i], string) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> putString(String[] stringArray, Charset charset) {
        this.pointerArray = new BytePointer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.pointerArray[i] = stringArray[i] != null ? new BytePointer(stringArray[i], charset) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(P ... PArray) {
        this.pointerArray = PArray;
        for (int i = 0; i < PArray.length; ++i) {
            this.put(i, (Pointer)PArray[i]);
        }
        return this;
    }

    public PointerPointer<P> put(byte[] ... byArray) {
        this.pointerArray = new BytePointer[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.pointerArray[i] = byArray[i] != null ? new BytePointer(byArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(short[] ... sArray) {
        this.pointerArray = new ShortPointer[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            this.pointerArray[i] = sArray[i] != null ? new ShortPointer(sArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(int[] ... nArray) {
        this.pointerArray = new IntPointer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.pointerArray[i] = nArray[i] != null ? new IntPointer(nArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(long[] ... lArray) {
        this.pointerArray = new LongPointer[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            this.pointerArray[i] = lArray[i] != null ? new LongPointer(lArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(float[] ... fArray) {
        this.pointerArray = new FloatPointer[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.pointerArray[i] = fArray[i] != null ? new FloatPointer(fArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(double[] ... dArray) {
        this.pointerArray = new DoublePointer[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.pointerArray[i] = dArray[i] != null ? new DoublePointer(dArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public PointerPointer<P> put(char[] ... cArray) {
        this.pointerArray = new CharPointer[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.pointerArray[i] = cArray[i] != null ? new CharPointer(cArray[i]) : null;
        }
        return this.put((Pointer[])this.pointerArray);
    }

    public Pointer get() {
        return this.get(0L);
    }

    public P get(Class<P> clazz) {
        return this.get(clazz, 0L);
    }

    public Pointer get(long l) {
        return this.get(Pointer.class, l);
    }

    public native P get(Class<P> var1, long var2);

    public PointerPointer<P> put(Pointer pointer) {
        return this.put(0L, pointer);
    }

    public native PointerPointer<P> put(long var1, Pointer var3);

    static {
        block2: {
            logger = Logger.create(PointerPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load PointerPointer: " + throwable);
            }
        }
    }
}

