/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class Bfloat16RawIndexer
extends Bfloat16Indexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public Bfloat16RawIndexer(ShortPointer shortPointer) {
        this(shortPointer, Index.create(shortPointer.limit() - shortPointer.position()));
    }

    public Bfloat16RawIndexer(ShortPointer shortPointer, long ... lArray) {
        this(shortPointer, Index.create(lArray));
    }

    public Bfloat16RawIndexer(ShortPointer shortPointer, long[] lArray, long[] lArray2) {
        this(shortPointer, Index.create(lArray, lArray2));
    }

    public Bfloat16RawIndexer(ShortPointer shortPointer, Index index) {
        super(index);
        this.pointer = shortPointer;
        this.base = shortPointer.address() + shortPointer.position() * 2L;
        this.size = shortPointer.limit() - shortPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public Bfloat16Indexer reindex(Index index) {
        return new Bfloat16RawIndexer(this.pointer, index);
    }

    public float getRaw(long l) {
        return Bfloat16RawIndexer.toFloat(RAW.getShort(this.base + Bfloat16RawIndexer.checkIndex(l, this.size) * 2L));
    }

    @Override
    public float get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public Bfloat16Indexer get(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public Bfloat16Indexer get(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public float get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public Bfloat16Indexer get(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public Bfloat16Indexer putRaw(long l, float f) {
        RAW.putShort(this.base + Bfloat16RawIndexer.checkIndex(l, this.size) * 2L, (short)Bfloat16RawIndexer.fromFloat(f));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long l, float f) {
        return this.putRaw(this.index(l), f);
    }

    @Override
    public Bfloat16Indexer put(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long l, long l2, float f) {
        this.putRaw(this.index(l, l2), f);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long l, long l2, long l3, float f) {
        this.putRaw(this.index(l, l2, l3), f);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] lArray, float f) {
        this.putRaw(this.index(lArray), f);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

