/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.CharIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class CharRawIndexer
extends CharIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected CharPointer pointer;
    final long base;
    final long size;

    public CharRawIndexer(CharPointer charPointer) {
        this(charPointer, Index.create(charPointer.limit() - charPointer.position()));
    }

    public CharRawIndexer(CharPointer charPointer, long ... lArray) {
        this(charPointer, Index.create(lArray));
    }

    public CharRawIndexer(CharPointer charPointer, long[] lArray, long[] lArray2) {
        this(charPointer, Index.create(lArray, lArray2));
    }

    public CharRawIndexer(CharPointer charPointer, Index index) {
        super(index);
        this.pointer = charPointer;
        this.base = charPointer.address() + charPointer.position() * 2L;
        this.size = charPointer.limit() - charPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public CharIndexer reindex(Index index) {
        return new CharRawIndexer(this.pointer, index);
    }

    public char getRaw(long l) {
        return RAW.getChar(this.base + CharRawIndexer.checkIndex(l, this.size) * 2L);
    }

    @Override
    public char get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public CharIndexer get(long l, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public char get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public CharIndexer get(long l, long l2, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public char get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public char get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public CharIndexer get(long[] lArray, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public CharIndexer putRaw(long l, char c) {
        RAW.putChar(this.base + CharRawIndexer.checkIndex(l, this.size) * 2L, c);
        return this;
    }

    @Override
    public CharIndexer put(long l, char c) {
        return this.putRaw(this.index(l), c);
    }

    @Override
    public CharIndexer put(long l, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, cArray[n + i]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long l, long l2, char c) {
        this.putRaw(this.index(l, l2), c);
        return this;
    }

    @Override
    public CharIndexer put(long l, long l2, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, cArray[n + i]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long l, long l2, long l3, char c) {
        this.putRaw(this.index(l, l2, l3), c);
        return this;
    }

    @Override
    public CharIndexer put(long[] lArray, char c) {
        this.putRaw(this.index(lArray), c);
        return this;
    }

    @Override
    public CharIndexer put(long[] lArray, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, cArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

