/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class FloatRawIndexer
extends FloatIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected FloatPointer pointer;
    final long base;
    final long size;

    public FloatRawIndexer(FloatPointer floatPointer) {
        this(floatPointer, Index.create(floatPointer.limit() - floatPointer.position()));
    }

    public FloatRawIndexer(FloatPointer floatPointer, long ... lArray) {
        this(floatPointer, Index.create(lArray));
    }

    public FloatRawIndexer(FloatPointer floatPointer, long[] lArray, long[] lArray2) {
        this(floatPointer, Index.create(lArray, lArray2));
    }

    public FloatRawIndexer(FloatPointer floatPointer, Index index) {
        super(index);
        this.pointer = floatPointer;
        this.base = floatPointer.address() + floatPointer.position() * 4L;
        this.size = floatPointer.limit() - floatPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public FloatIndexer reindex(Index index) {
        return new FloatRawIndexer(this.pointer, index);
    }

    public float getRaw(long l) {
        return RAW.getFloat(this.base + FloatRawIndexer.checkIndex(l, this.size) * 4L);
    }

    @Override
    public float get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public FloatIndexer get(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public FloatIndexer get(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public float get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public FloatIndexer get(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public FloatIndexer putRaw(long l, float f) {
        RAW.putFloat(this.base + FloatRawIndexer.checkIndex(l, this.size) * 4L, f);
        return this;
    }

    @Override
    public FloatIndexer put(long l, float f) {
        return this.putRaw(this.index(l), f);
    }

    @Override
    public FloatIndexer put(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long l, long l2, float f) {
        this.putRaw(this.index(l, l2), f);
        return this;
    }

    @Override
    public FloatIndexer put(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long l, long l2, long l3, float f) {
        this.putRaw(this.index(l, l2, l3), f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] lArray, float f) {
        this.putRaw(this.index(lArray), f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

