/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.Index;

public class StrideIndex
extends Index {
    protected final long[] strides;

    public static long[] defaultStrides(long ... lArray) {
        long[] lArray2 = new long[lArray.length];
        lArray2[lArray.length - 1] = 1L;
        for (int i = lArray.length - 2; i >= 0; --i) {
            lArray2[i] = lArray2[i + 1] * lArray[i + 1];
        }
        return lArray2;
    }

    public StrideIndex(long ... lArray) {
        this(lArray, StrideIndex.defaultStrides(lArray));
    }

    public StrideIndex(long[] lArray, long[] lArray2) {
        super(lArray);
        this.strides = lArray2;
    }

    public long[] strides() {
        return this.strides;
    }

    @Override
    public long index(long l) {
        return l * this.strides[0];
    }

    @Override
    public long index(long l, long l2) {
        return l * this.strides[0] + l2 * this.strides[1];
    }

    @Override
    public long index(long l, long l2, long l3) {
        return l * this.strides[0] + l2 * this.strides[1] + l3 * this.strides[2];
    }

    @Override
    public long index(long ... lArray) {
        long l = 0L;
        for (int i = 0; i < lArray.length && i < this.strides.length; ++i) {
            l += lArray[i] * this.strides[i];
        }
        return l;
    }
}

