/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.LongBuffer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.ULongIndexer;

public class ULongBufferIndexer
extends ULongIndexer {
    protected LongBuffer buffer;

    public ULongBufferIndexer(LongBuffer longBuffer) {
        this(longBuffer, Index.create((long)longBuffer.limit()));
    }

    public ULongBufferIndexer(LongBuffer longBuffer, long ... lArray) {
        this(longBuffer, Index.create(lArray));
    }

    public ULongBufferIndexer(LongBuffer longBuffer, long[] lArray, long[] lArray2) {
        this(longBuffer, Index.create(lArray, lArray2));
    }

    public ULongBufferIndexer(LongBuffer longBuffer, Index index) {
        super(index);
        this.buffer = longBuffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    public ULongIndexer reindex(Index index) {
        return new ULongBufferIndexer(this.buffer, index);
    }

    @Override
    public BigInteger get(long l) {
        return ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(l)));
    }

    @Override
    public ULongIndexer get(long l, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(l) + i));
        }
        return this;
    }

    @Override
    public BigInteger get(long l, long l2) {
        return ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(l, l2)));
    }

    @Override
    public ULongIndexer get(long l, long l2, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(l, l2) + i));
        }
        return this;
    }

    @Override
    public BigInteger get(long l, long l2, long l3) {
        return ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(l, l2, l3)));
    }

    @Override
    public BigInteger get(long ... lArray) {
        return ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(lArray)));
    }

    @Override
    public ULongIndexer get(long[] lArray, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = ULongBufferIndexer.toBigInteger(this.buffer.get((int)this.index(lArray) + i));
        }
        return this;
    }

    @Override
    public ULongIndexer put(long l, BigInteger bigInteger) {
        this.buffer.put((int)this.index(l), ULongBufferIndexer.fromBigInteger(bigInteger));
        return this;
    }

    @Override
    public ULongIndexer put(long l, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(l) + i, ULongBufferIndexer.fromBigInteger(bigIntegerArray[n + i]));
        }
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, BigInteger bigInteger) {
        this.buffer.put((int)this.index(l, l2), ULongBufferIndexer.fromBigInteger(bigInteger));
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(l, l2) + i, ULongBufferIndexer.fromBigInteger(bigIntegerArray[n + i]));
        }
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, long l3, BigInteger bigInteger) {
        this.buffer.put((int)this.index(l, l2, l3), ULongBufferIndexer.fromBigInteger(bigInteger));
        return this;
    }

    @Override
    public ULongIndexer put(long[] lArray, BigInteger bigInteger) {
        this.buffer.put((int)this.index(lArray), ULongBufferIndexer.fromBigInteger(bigInteger));
        return this;
    }

    @Override
    public ULongIndexer put(long[] lArray, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(lArray) + i, ULongBufferIndexer.fromBigInteger(bigIntegerArray[n + i]));
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

