/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.LongBuffer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.ULongArrayIndexer;
import org.bytedeco.javacpp.indexer.ULongBufferIndexer;
import org.bytedeco.javacpp.indexer.ULongRawIndexer;

public abstract class ULongIndexer
extends Indexer {
    public static final int VALUE_BYTES = 8;

    protected ULongIndexer(Index index) {
        super(index);
    }

    protected ULongIndexer(long[] lArray, long[] lArray2) {
        super(lArray, lArray2);
    }

    public static ULongIndexer create(long[] lArray) {
        return new ULongArrayIndexer(lArray);
    }

    public static ULongIndexer create(LongBuffer longBuffer) {
        return new ULongBufferIndexer(longBuffer);
    }

    public static ULongIndexer create(LongPointer longPointer) {
        return new ULongRawIndexer(longPointer);
    }

    public static ULongIndexer create(long[] lArray, Index index) {
        return new ULongArrayIndexer(lArray, index);
    }

    public static ULongIndexer create(LongBuffer longBuffer, Index index) {
        return new ULongBufferIndexer(longBuffer, index);
    }

    public static ULongIndexer create(LongPointer longPointer, Index index) {
        return new ULongRawIndexer(longPointer, index);
    }

    public static ULongIndexer create(long[] lArray, long ... lArray2) {
        return new ULongArrayIndexer(lArray, lArray2);
    }

    public static ULongIndexer create(LongBuffer longBuffer, long ... lArray) {
        return new ULongBufferIndexer(longBuffer, lArray);
    }

    public static ULongIndexer create(LongPointer longPointer, long ... lArray) {
        return new ULongRawIndexer(longPointer, lArray);
    }

    public static ULongIndexer create(long[] lArray, long[] lArray2, long[] lArray3) {
        return new ULongArrayIndexer(lArray, lArray2, lArray3);
    }

    public static ULongIndexer create(LongBuffer longBuffer, long[] lArray, long[] lArray2) {
        return new ULongBufferIndexer(longBuffer, lArray, lArray2);
    }

    public static ULongIndexer create(LongPointer longPointer, long[] lArray, long[] lArray2) {
        return new ULongRawIndexer(longPointer, lArray, lArray2);
    }

    public static ULongIndexer create(LongPointer longPointer, long[] lArray, long[] lArray2, boolean bl) {
        return ULongIndexer.create(longPointer, Index.create(lArray, lArray2), bl);
    }

    public static ULongIndexer create(final LongPointer longPointer, Index index, boolean bl) {
        if (bl) {
            return Raw.getInstance() != null ? new ULongRawIndexer(longPointer, index) : new ULongBufferIndexer(longPointer.asBuffer(), index);
        }
        final long l = longPointer.position();
        long[] lArray = new long[(int)Math.min(longPointer.limit() - l, Integer.MAX_VALUE)];
        longPointer.get(lArray);
        return new ULongArrayIndexer(lArray, index){

            @Override
            public void release() {
                longPointer.position(l).put(this.array);
                super.release();
            }
        };
    }

    public static BigInteger toBigInteger(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l & Long.MAX_VALUE);
        if (l < 0L) {
            bigInteger = bigInteger.setBit(63);
        }
        return bigInteger;
    }

    public static long fromBigInteger(BigInteger bigInteger) {
        return bigInteger.longValue();
    }

    public abstract BigInteger get(long var1);

    public ULongIndexer get(long l, BigInteger[] bigIntegerArray) {
        return this.get(l, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer get(long var1, BigInteger[] var3, int var4, int var5);

    public abstract BigInteger get(long var1, long var3);

    public ULongIndexer get(long l, long l2, BigInteger[] bigIntegerArray) {
        return this.get(l, l2, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer get(long var1, long var3, BigInteger[] var5, int var6, int var7);

    public abstract BigInteger get(long var1, long var3, long var5);

    public abstract BigInteger get(long ... var1);

    public ULongIndexer get(long[] lArray, BigInteger[] bigIntegerArray) {
        return this.get(lArray, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer get(long[] var1, BigInteger[] var2, int var3, int var4);

    public abstract ULongIndexer put(long var1, BigInteger var3);

    public ULongIndexer put(long l, BigInteger ... bigIntegerArray) {
        return this.put(l, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer put(long var1, BigInteger[] var3, int var4, int var5);

    public abstract ULongIndexer put(long var1, long var3, BigInteger var5);

    public ULongIndexer put(long l, long l2, BigInteger ... bigIntegerArray) {
        return this.put(l, l2, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer put(long var1, long var3, BigInteger[] var5, int var6, int var7);

    public abstract ULongIndexer put(long var1, long var3, long var5, BigInteger var7);

    public abstract ULongIndexer put(long[] var1, BigInteger var2);

    public ULongIndexer put(long[] lArray, BigInteger ... bigIntegerArray) {
        return this.put(lArray, bigIntegerArray, 0, bigIntegerArray.length);
    }

    public abstract ULongIndexer put(long[] var1, BigInteger[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... lArray) {
        return this.get(lArray).doubleValue();
    }

    @Override
    public ULongIndexer putDouble(long[] lArray, double d) {
        return this.put(lArray, BigDecimal.valueOf(d).toBigInteger());
    }
}

