/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import org.bytedeco.javacpp.tools.ParserException;

class Token
implements Comparable<Token> {
    static final int INTEGER = 1;
    static final int FLOAT = 2;
    static final int STRING = 3;
    static final int COMMENT = 4;
    static final int IDENTIFIER = 5;
    static final int SYMBOL = 6;
    static final Token EOF = new Token(-1, "EOF");
    static final Token AUTO = new Token(5, "auto");
    static final Token CONST = new Token(5, "const");
    static final Token __CONST = new Token(5, "__const");
    static final Token CONSTEXPR = new Token(5, "constexpr");
    static final Token DECLTYPE = new Token(5, "decltype");
    static final Token DEFAULT = new Token(5, "default");
    static final Token DEFINE = new Token(5, "define");
    static final Token IF = new Token(5, "if");
    static final Token IFDEF = new Token(5, "ifdef");
    static final Token IFNDEF = new Token(5, "ifndef");
    static final Token ELIF = new Token(5, "elif");
    static final Token ELSE = new Token(5, "else");
    static final Token ENDIF = new Token(5, "endif");
    static final Token UNDEF = new Token(5, "undef");
    static final Token ENUM = new Token(5, "enum");
    static final Token EXPLICIT = new Token(5, "explicit");
    static final Token EXTERN = new Token(5, "extern");
    static final Token FINAL = new Token(5, "final");
    static final Token FRIEND = new Token(5, "friend");
    static final Token INLINE = new Token(5, "inline");
    static final Token STATIC = new Token(5, "static");
    static final Token CLASS = new Token(5, "class");
    static final Token INTERFACE = new Token(5, "interface");
    static final Token __INTERFACE = new Token(5, "__interface");
    static final Token MUTABLE = new Token(5, "mutable");
    static final Token STRUCT = new Token(5, "struct");
    static final Token UNION = new Token(5, "union");
    static final Token TEMPLATE = new Token(5, "template");
    static final Token TYPEDEF = new Token(5, "typedef");
    static final Token TYPENAME = new Token(5, "typename");
    static final Token USING = new Token(5, "using");
    static final Token NAMESPACE = new Token(5, "namespace");
    static final Token NEW = new Token(5, "new");
    static final Token DELETE = new Token(5, "delete");
    static final Token OPERATOR = new Token(5, "operator");
    static final Token OVERRIDE = new Token(5, "override");
    static final Token PRIVATE = new Token(5, "private");
    static final Token PROTECTED = new Token(5, "protected");
    static final Token PUBLIC = new Token(5, "public");
    static final Token REGISTER = new Token(5, "register");
    static final Token THREAD_LOCAL = new Token(5, "thread_local");
    static final Token VIRTUAL = new Token(5, "virtual");
    static final Token VOLATILE = new Token(5, "volatile");
    File file = null;
    String text = null;
    int lineNumber = 0;
    int type = -1;
    String spacing = "";
    String value = "";

    Token() {
    }

    Token(int n, String string) {
        this.type = n;
        this.value = string;
    }

    Token(Token token) {
        this.file = token.file;
        this.text = token.text;
        this.lineNumber = token.lineNumber;
        this.type = token.type;
        this.spacing = token.spacing;
        this.value = token.value;
    }

    boolean match(Object ... objectArray) {
        boolean bl = false;
        for (Object object : objectArray) {
            bl = bl || this.equals(object);
        }
        return bl;
    }

    Token expect(Object ... objectArray) {
        if (!this.match(objectArray)) {
            throw new ParserException(this.file + ":" + this.lineNumber + ":" + (this.text != null ? "\"" + this.text + "\": " : "") + "Unexpected token '" + this.toString() + "'");
        }
        return this;
    }

    boolean isEmpty() {
        return this.type == -1 && this.spacing.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == Integer.class) {
            return this.type == (Integer)object;
        }
        if (object.getClass() == Character.class) {
            return this.type == ((Character)object).charValue();
        }
        if (object.getClass() == String.class) {
            return object.equals(this.value);
        }
        if (object.getClass() == this.getClass()) {
            Token token = (Token)object;
            return this.type == token.type && (this.value == null && token.value == null || this.value != null && this.value.equals(token.value));
        }
        return false;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.value != null && this.value.length() > 0 ? this.value : String.valueOf((char)this.type);
    }

    @Override
    public int compareTo(Token token) {
        return this.toString().compareTo(token.toString());
    }
}

